<?php
/**
 * 2024 Mapplico
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@mapplico.com so we can send you a copy immediately.
 *
 * @author    Mapplico <info@mapplico.com>
 * @copyright 2024 Mapplico
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of Mapplico
 */
use Prestashop\ModuleLibMboInstaller\DependencyBuilder;
use PrestaShop\ModuleLibServiceContainer\DependencyInjection\ServiceContainer;
use PrestaShop\Prestashop\Core\Addon\Module\ModuleManagerBuilder;

if (!defined('_PS_VERSION_')) {
    exit;
}

$autoloadPath = __DIR__ . '/vendor/autoload.php';
if (file_exists($autoloadPath)) {
    require_once $autoloadPath;
}

class Mapplico extends Module
{
    protected $config_form = false;

    private $container;

    public $useLightMode;

    public function __construct()
    {
        $this->name = 'mapplico';
        $this->tab = 'mobile';
        $this->version = '1.0.0';
        $this->author = 'Mapplico Team';
        $this->need_instance = 0;
        $this->module_key = '3d86df4bf7a6d8ba42b9a5fa970d5792';
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Mapplico module for Prestashop');
        $this->description = $this->l('The one-stop shop to transform your commerce store into a mobile app!');

        $this->ps_versions_compliancy = ['min' => '1.7.0', 'max' => _PS_VERSION_];

        $this->useLightMode = true;

        if ($this->container === null) {
            $this->container = new ServiceContainer(
                $this->name,
                $this->getLocalPath()
            );
        }
    }

    public function install()
    {
        return parent::install();
    }

    public function uninstall()
    {
        return parent::uninstall();
    }

    /**
     * Load the configuration content
     */
    public function getContent()
    {
        $mboInstaller = new DependencyBuilder($this);
        if (!$mboInstaller->areDependenciesMet()) {
            $dependencies = $mboInstaller->handleDependencies();
            $this->smarty->assign('dependencies', $dependencies);
            return $this->display(__FILE__, 'views/templates/admin/dependency_builder.tpl');
        }

        $this->context->smarty->assign('module_dir', $this->_path);
        $moduleManager = ModuleManagerBuilder::getInstance()->build();
        $accountsService = null;

        try {
            $accountsFacade = $this->getService('mapplico.ps_accounts_facade');
            $accountsService = $accountsFacade->getPsAccountsService();
        } catch (InstallerException $e) {
            $accountsInstaller = $this->getService('mapplico.ps_accounts_installer');
            $accountsInstaller->install();
            $accountsFacade = $this->getService('mapplico.ps_accounts_facade');
            $accountsService = $accountsFacade->getPsAccountsService();
        }

        try {
            Media::addJsDef([
                'contextPsAccounts' => $accountsFacade->getPsAccountsPresenter()
                    ->present($this->name),
            ]);
            // Retrieve Account CDN
            $this->context->smarty->assign('urlAccountsCdn', $accountsService->getAccountsCdn());
        } catch (Exception $e) {
            $this->context->controller->errors[] = $e->getMessage();
            return '';
        }

        if ($moduleManager->isInstalled('ps_eventbus')) {
            $eventbusModule = Module::getInstanceByName('ps_eventbus');
            if (version_compare($eventbusModule->version, '1.9.0', '>=')) {
                $eventbusPresenterService = $eventbusModule->getService('PrestaShop\Module\PsEventbus\Service\PresenterService');
                // $this->context->smarty->assign('urlCloudsync', 'https://assets.prestashop3.com/ext/cloudsync-merchant-sync-consent/latest/cloudsync-cdc.js');
                Media::addJsDef(['contextPsEventbus' => $eventbusPresenterService->expose($this, ['info', 'modules', 'themes'])]);
            }
        }

        /**********************
         * PrestaShop Billing *
         * *******************/

        // Load context for PsBilling
        $billingFacade = $this->getService('mapplico.ps_billings_facade');
        $partnerLogo = $this->getLocalPath() . 'logo.png';

        // Billing
        Media::addJsDef($billingFacade->present([
            'logo' => $partnerLogo,
            'tosLink' => 'https://www.mapplico.com/terms-and-conditions',
            'privacyLink' => 'https://www.mapplico.com/privacy-policy',
            'emailSupport' => 'info@mapplico.com',
        ]));

        $this->context->smarty->assign('urlBilling', 'https://unpkg.com/@prestashopcorp/billing-cdc/dist/bundle.js');

        $output = $this->context->smarty->fetch($this->local_path . 'views/templates/admin/configure.tpl');
        return $output;
    }

    /**
     * Retrieve service
     *
     * @param string $serviceName
     *
     * @return mixed
     */
    public function getService($serviceName)
    {
        return $this->container->getService($serviceName);
    }
}
