{*
* 2024 Mapplico
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2024 Mapplico
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<prestashop-accounts></prestashop-accounts>
<br>
<div id="prestashop-cloudsync"></div>

<div id="ps-billing"></div>
<div id="ps-modal"></div>

<br>

<div id="module-config">

    <div class="panel">
        <h3><i class="icon icon-credit-card"></i>Mapplico module for Prestashop</h3>
        <p>
            <strong>Welcome to the Mapplico Family!</strong>
            <br/>
            We are delighted to welcome you to our community by choosing the Mapplico mobile application. Our goal is to
            provide you with the best mobile experience, and we are thrilled to have you with us on this journey.
        </p>
        <p>
            <strong>Here are the key benefits of our mobile application:</strong>
            <br/>
            - Real-Time Communication: Send instant and effective notifications to your customers.
            <br/>
            - Increased Sales and Conversions: Boost your sales and customer conversions with discounts and special
            offers.
            <br/>
            - Customer Loyalty: Strengthen your customer relationships through timely and relevant updates.
            <br/>
            - Enhanced User Experience: Save your customers time by delivering valuable content and updates directly to
            them.
            <br/>
            - No need on your side for any additional configuration. We do the heavy lifting for you.
        </p>
        <p>
            <strong>Our Customer Success team will contact you within 24 hours after your purchase to better assist you
                with your needs.</strong>
            <br/>
            Thank you once again, and we look forward to a successful collaboration.<br/>
            Best regards,<br/>
            The Mapplico Team
        </p>
    </div>
</div>

<script src="{$urlAccountsCdn|escape:'htmlall':'UTF-8'}" rel=preload></script>
<script src="{$urlCloudsync|escape:'htmlall':'UTF-8'}"></script>
<script src="{$urlBilling|escape:'htmlall':'UTF-8'}"></script>

<script>
    window?.psaccountsVue?.init();

    if (window.psaccountsVue.isOnboardingCompleted() != true) {
        document.getElementById("module-config").style.opacity = "0.5";
    }

    // Cloud Sync
    //const cdc = window.cloudSyncSharingConsent;

    //cdc.init('#prestashop-cloudsync');
    // cdc.on('OnboardingCompleted', (isCompleted) => {
    // 	console.log('OnboardingCompleted', isCompleted);
    //
    // });
    // cdc.isOnboardingCompleted((isCompleted) => {
    // 	console.log('Onboarding is already Completed', isCompleted);
    // });


    window.psBilling.initialize(window.psBillingContext.context, '#ps-billing', '#ps-modal', (type, data) => {
        // Event hook listener
        switch (type) {
            case window.psBilling.EVENT_HOOK_TYPE.BILLING_INITIALIZED:
                console.log('Billing initialized', data);
                break;
            case window.psBilling.EVENT_HOOK_TYPE.SUBSCRIPTION_UPDATED:
                console.log('Sub updated', data);
                break;
            case window.psBilling.EVENT_HOOK_TYPE.SUBSCRIPTION_CANCELLED:
                console.log('Sub cancelled', data);
                break;
        }
    });
</script>
