<?php
/**
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2019 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

namespace PrestaShop\Module\PrestashopCheckout\Api\Psx;

use PrestaShop\Module\PrestashopCheckout\Api\Client\PsxClient;

class Onboarding extends PsxClient
{
    /**
     * Collect merchant data during PSX onboarding process. These data are intended to be shared across PSX services.
     *
     * @param array $data
     *
     * @return false|array false if good | array if errors returned
     */
    public function setOnboardingMerchant(array $data)
    {
        $this->setRoute('/psx/onboarding/merchant');

        return $this->post([
            'json' => json_encode($data),
        ]);
    }
}
