<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminAlerts
{
    /**
     * Check for alerts.
     *
     * @return boolean
     */
    public static function isAlerts()
    {
        return (count(self::getAlerts()) > 0 ? true : false);
    }
    
    /**
     * Get alerts.
     *
     * @return array
     */
    public static function getAlerts()
    {
        $translator = new LinevenRlpTranslator();
        $return = array();
        // Count associations to display
        $count_associations = count(LinevenRlpAssociation::getAssociations());
        if ($count_associations == 0) {
            $return[] = array(
                'icon' => 'fa fa-exclamation-circle',
                'message' => $translator->l('You have not defined associations. Click here to create associations.', 'Alerts'),
                'color' => '#D2A63C',
                'href' => LinevenRlpTools::getBackofficeURI('Associations', 'addEdit', 'associations:plugin_associations:add')
            );
        }
        $pages_defs = array(
            'OHP' => array(
                'image_type' => false,
                'template_folder' => 'home',
                'template_error' => $translator->l('Smarty template used in home page is not exists in folder. Check your configuration.', 'Alerts')
            ),
            'OCL' => array(
                'image_type' => true,
                'template_folder' => 'column',
                'image_error' => $translator->l('Product image used is not a correct product image type for column. Check the display configuration.', 'Alerts'),
                'template_error' => $translator->l('Smarty template used in column is not exists in folder. Check your configuration.', 'Alerts')
            ),
            'OPP' => array(
                'image_type' => true,
                'template_folder' => 'productpage',
                'image_error' => $translator->l('Product image used is not a correct product image type for product page. Check the display configuration.', 'Alerts'),
                'template_error' => $translator->l('Smarty template used in product page is not exists in folder. Check your configuration.', 'Alerts')
            ),
            'OQV' => array(
                'image_type' => true,
                'template_folder' => 'quickview',
                'image_error' => $translator->l('Product image used is not a correct product image type for quick view. Check the display configuration.', 'Alerts'),
                'template_error' => $translator->l('Smarty template used in quick view is not exists in folder. Check your configuration.', 'Alerts')
            ),
            'OOP' => array(
                'image_type' => true,
                'template_folder' => 'shoppingcart',
                'image_error' => $translator->l('Product image used is not a correct product image type for order page. Check the display configuration.', 'Alerts'),
                'template_error' => $translator->l('Smarty template used in order page is not exists in folder. Check your configuration.', 'Alerts')
            ),
            'OAC' => array(
                'image_type' => true,
                'template_folder' => 'ajaxcart',
                'image_error' => $translator->l('Product image used is not a correct product image type for ajax cart. Check the display configuration.', 'Alerts'),
                'template_error' => $translator->l('Smarty template used in ajax cart is not exists in folder. Check your configuration.', 'Alerts')
            ),
        );
        foreach ($pages_defs as $configuration_code => $defs) {
            if ($defs['image_type']) {
                // Check product image
                if (!LinevenRlpAdminDiagnostic::checkProductImageUsed($configuration_code)) {
                    $return[] = array(
                        'icon' => 'fa fa-exclamation-circle',
                        'message' => $defs['image_error'],
                        'color' => '#D2A63C'
                    );
                }
            }
            if (!LinevenRlpAdminDiagnostic::checkSmartyTemplateUsed($configuration_code, $defs['template_folder'])) {
                $return[] = array(
                    'icon' => 'fa fa-exclamation-circle',
                    'message' => $defs['template_error'],
                    'color' => '#D2A63C'
                );
            }
        }
        $return = array_merge(LinevenRlpModuleAlerts::getAlerts(), $return);
        return $return;
    }
}
