<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminDiagnostic extends LinevenRlpModuleDiagnostic
{
    /**
     * Execute.
     *
     * @return array
     */
    public function execute()
    {
        parent::execute();
        // Specific execution here
        if ($this->is_success) {
            switch ($this->what) {
                case 'hooks':
                    $this->is_success = self::repairHooksByConfiguration();
                    break;
            }
        }
        return $this->is_success;
    }

    /**
     * Check hooks by configuration.
     *
     * @return array
     */
    public static function checkHooksByConfiguration()
    {
        $items = array();
        if (Configuration::get('LINEVEN_RLP_SPECIFIC_HOOK_DEF') &&
            Configuration::get('LINEVEN_RLP_SPECIFIC_HOOK_DEF') != '') {
            $configuration = LinevenRlpConfiguration::getConfiguration();
            $hooks_def = unserialize(Configuration::get('LINEVEN_RLP_SPECIFIC_HOOK_DEF'));
            foreach ($hooks_def as $hook_name => $page_name) {
                if (!$configuration->isHookRegistred($hook_name)) {
                    $items[] = $hook_name;
                }
            }
        }
        return $items;
    }

    /**
     * Check product image used.
     *
     * @return boolean
     */
    public static function checkProductImageUsed($configuration_code)
    {
        $id_image_type_used = Configuration::get('LINEVEN_RLP_'.$configuration_code.'_IMAGE_TYPE');
        $name_image_type_used = Configuration::get('LINEVEN_RLP_'.$configuration_code.'_IMAGE_TYPE_NAME');
        $products_image = ImageType::getImagesTypes('products', true);
        $found = false;
        if (count($products_image)) {
            foreach ($products_image as $image) {
                if ($image['id_image_type'] == $id_image_type_used &&
                    $image['name'] == $name_image_type_used
                ) {
                    $found = true;
                    break;
                }
            }
        }
        return $found;
    }

    /*
     * Check smarty template used.
     *
     * @param string $configuration_code Configuration code
     * @param string $folder Folder
     * @return boolean
     */
    public static function checkSmartyTemplateUsed($configuration_code, $folder)
    {
        $template_file = Configuration::get('LINEVEN_RLP_'.$configuration_code.'_DISPLAYING_MODE');
        $template_file = Tools::strtolower($template_file).'.tpl';
        return is_file(
            _LINEVEN_MODULE_RLP_REQUIRE_DIR_.'/views/templates/hook/'.$folder.'/'.Tools::strtolower($template_file)
        );
    }

    /**
     * Repair hooks by configuration.
     */
    public static function repairHooksByConfiguration()
    {
        if (Configuration::get('LINEVEN_RLP_SPECIFIC_HOOK_DEF') &&
            Configuration::get('LINEVEN_RLP_SPECIFIC_HOOK_DEF') != '') {
            $configuration = LinevenRlpConfiguration::getConfiguration();
            $hooks_def = unserialize(Configuration::get('LINEVEN_RLP_SPECIFIC_HOOK_DEF'));
            foreach ($hooks_def as $hook_name => $page_name) {
                if (!$configuration->isHookRegistred($hook_name)) {
                    $configuration->getModule()->registerHook($hook_name);
                }
            }
        }
        return true;
    }
}
