<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAssociation extends LinevenRlpModel
{
    /**
     * Id
     * @var int
     */
    public $id;

    /**
     * Id shop group
     * @var int
     */
    public $id_shop_group;

    /**
     * Id shop
     * @var int
     */
    public $id_shop;

    /**
     * Name
     * @var string
     */
    public $name;

    /**
     * Short description
     * @var string
     */
    public $short_description;

    /**
     * Comment
     * @var string
     */
    public $comments;

    /**
     * Category id
     * @var integer
     */
    public $category_id;

    /**
     * Related product id
     * @var integer
     */
    public $related_product_id;

    /**
     * Related products keywords
     * @var string
     */
    public $related_products_keywords;
    
    /**
     * Product id
     * @var int
     */
    public $product_id;

    /**
     * Category products id
     * @var integer
     */
    public $category_products_id;

    /**
     * Products keywords
     * @var string
     */
    public $products_keywords;
    
    /**
     * Is reciprocity
     * @var int
     */
    public $is_reciprocity;

    /**
     * Is keywords rules active
     * @var int
     */
    public $is_keywords_rules_active;

    /**
     * Is keywords rules by reference
     * @var int
     */
    public $is_keywords_rules_reference;

    /**
     * Is keywords rules by name
     * @var int
     */
    public $is_keywords_rules_name;

    /**
     * Is keywords rules by description
     * @var int
     */
    public $is_keywords_rules_description;

    /**
     * Hooks
     * @var string
     */
    public $hooks;

    /**
     * Order display
     * @var integer
     */
    public $order_display;

    /**
     * Association type
     * @var string
     */
    public $association_type;

    /**
     * Display choice
     * @var string
     */
    public $display_choice;


    /**
     * Keywords rules.
     * @var array
     */
    public $keywords_rules;

    /**
     * Options
     * @var string
     */
    public $options;
    
    public static $related_products_type_all        = 'ALL';        /* All type */
    public static $related_products_type_category   = 'CATEGORY';   /* Category type */
    public static $related_products_type_product    = 'PRODUCT';    /* Product type */
    public static $related_products_type_keywords   = 'KEYWORDS';   /* Keywords */

    public static $related_display_category         = 'CATEGORY';   /* Category */
    public static $related_display_product          = 'PRODUCT';    /* Product */
    public static $related_display_keywords         = 'KEYWORDS';   /* Keywords */

    /**
     * Constructor.
     * @param int $id Identifier
     */
    public function __construct($id = null)
    {
        self::$definition = array(
            'table' => 'lineven_rlp',
            'primary' => 'id',
            'fields' => array(
                'id_shop' => array(
                    'type' => self::TYPE_INT,
                    'validate' => 'isUnsignedId',
                    'required' => false
                ),
                'id_shop_group' => array(
                    'type' => self::TYPE_INT,
                    'validate' => 'isUnsignedId',
                    'required' => false
                ),
                'name' => array(
                    'type' => self::TYPE_STRING,
                    'validate' => 'isString',
                    'required' => false
                ),
                'short_description' => array(
                    'type' => self::TYPE_STRING,
                    'validate' => 'isString',
                    'required' => false
                ),
                'comments' => array(
                    'type' => self::TYPE_STRING,
                    'validate' => 'isString',
                    'required' => false
                ),
                'category_id' => array(
                    'type' => self::TYPE_INT,
                    'validate' => 'isUnsignedId',
                    'required' => false
                ),
                'related_product_id' => array(
                    'type' => self::TYPE_INT,
                    'validate' => 'isUnsignedId',
                    'required' => false
                ),
                'related_products_keywords' => array(
                    'type' => self::TYPE_STRING,
                    'validate' => 'isString',
                    'required' => false
                ),
                'product_id' => array(
                    'type' => self::TYPE_INT,
                    'validate' => 'isUnsignedId',
                    'required' => true
                ),
                'category_products_id' => array(
                    'type' => self::TYPE_INT,
                    'validate' => 'isUnsignedId',
                    'required' => true
                ),
                'products_keywords' => array(
                    'type' => self::TYPE_STRING,
                    'validate' => 'isString',
                    'required' => false
                ),
                'is_reciprocity' => array(
                    'type' => self::TYPE_BOOL,
                    'validate' => 'isInt',
                    'required' => true
                ),
                'is_keywords_rules_active' => array(
                    'type' => self::TYPE_BOOL,
                    'validate' => 'isInt',
                    'required' => true
                ),
                'is_keywords_rules_reference' => array(
                    'type' => self::TYPE_BOOL,
                    'validate' => 'isInt',
                    'required' => true
                ),
                'is_keywords_rules_name' => array(
                    'type' => self::TYPE_BOOL,
                    'validate' => 'isInt',
                    'required' => true
                ),
                'is_keywords_rules_description' => array(
                    'type' => self::TYPE_BOOL,
                    'validate' => 'isInt',
                    'required' => true
                ),
                'minimum_amount' => array(
                    'type' => self::TYPE_FLOAT,
                    'validate' => 'isFloat',
                    'required' => false
                ),
                'hooks' => array(
                    'type' => self::TYPE_STRING,
                    'validate' => 'isString',
                    'required' => false
                ),
                'order_display' => array(
                    'type' => self::TYPE_INT,
                    'validate' => 'isInt',
                    'required' => false
                ),
                'options' => array(
                    'type' => self::TYPE_STRING,
                    'validate' => 'isString',
                    'required' => false
                )
            )
        );
        parent::__construct($id);
        if ($id) {
            // Default
            $this->association_type = self::$related_products_type_all;
            $this->display_choice = self::$related_display_product;
            if ($this->category_id != '' && $this->category_id != 0) {
                $this->association_type = self::$related_products_type_category;
            }
            if ($this->related_product_id != '' && $this->related_product_id != 0) {
                $this->association_type = self::$related_products_type_product;
            }
            if ($this->related_products_keywords != '' && $this->related_products_keywords != '') {
                $this->association_type = self::$related_products_type_keywords;
            }
            if ($this->category_products_id != '' && $this->category_products_id != 0) {
                $this->display_choice = self::$related_display_category;
            }
            if ($this->products_keywords != '') {
                $this->display_choice = self::$related_display_keywords;
            }
            $this->name = unserialize($this->name);
            $this->short_description = unserialize($this->short_description);
            $this->options = unserialize($this->options);
        } else {
            $this->association_type = self::$related_products_type_all;
            $this->display_choice = self::$related_display_product;
            $this->is_keywords_rules_active = 0;
            $this->is_keywords_rules_reference = 0;
            $this->is_keywords_rules_name = 0;
            $this->is_keywords_rules_description = 0;
            $this->hooks = null;
        }
        $this->setRules();
    }

    /**
     * Update association.
     * @param LinevenRlpForm $form Form.
     * @return boolean
     */
    public static function staticUpdate($form)
    {
        $fields_values = $form->getFieldsValue();
        $id_association = null;
        if (isset($fields_values['id']) && $fields_values['id'] != 0 && $fields_values['id'] != '') {
            $id_association = (int)$fields_values['id'];
        }

        $id_related_category = 'null';
        $id_related_product = 'null';
        $related_keywords = 'null';
        switch ($fields_values['association_type']) {
            case LinevenRlpAssociation::$related_products_type_all:
                break;
            case LinevenRlpAssociation::$related_products_type_category:
                $id_related_category = (int)$fields_values['category_id'];
                break;
            case LinevenRlpAssociation::$related_products_type_product:
                $id_related_product = (int)$fields_values['related_product_id'];
                break;
            case LinevenRlpAssociation::$related_products_type_keywords:
                $related_keywords = '"'.addslashes($fields_values['related_products_keywords']).'"';
                break;
        }
        $id_category_products = 'null';
        $id_product = 'null';
        $product_keywords = 'null';
        switch ($fields_values['display_choice']) {
            case LinevenRlpAssociation::$related_display_category:
                $id_category_products = (int)$fields_values['category_products_id'];
                break;
            case LinevenRlpAssociation::$related_display_product:
                $id_product = (int)$fields_values['product_id'];
                break;
            case LinevenRlpAssociation::$related_display_keywords:
                $product_keywords = '"'.addslashes($fields_values['products_keywords']).'"';
                break;
        }

        // Search specific rules
        $is_keywords_rules_reference = 0;
        $is_keywords_rules_name = 0;
        $is_keywords_rules_description = 0;
        if ((int)$fields_values['is_keywords_rules_active']) {
            if (Tools::isSubmit('keywords_rules')) {
                $keywords_rules_values = Tools::getValue('keywords_rules');
                foreach ($keywords_rules_values as $value) {
                    switch ($value) {
                        case 'reference':
                            $is_keywords_rules_reference = 1;
                            break;
                        case 'name':
                            $is_keywords_rules_name = 1;
                            break;
                        case 'description':
                            $is_keywords_rules_description = 1;
                            break;
                    }
                }
            }
        }

        // Hooks
        $which_hooks = '';
        if (isset($fields_values['which_hooks']) && is_array($fields_values['which_hooks']) && count($fields_values['which_hooks'])) {
            $which_hooks = implode('|', $fields_values['which_hooks']);
        }

        // Add
        if ($id_association == null || $id_association == ''|| $id_association == 0) {
            $id_shop_group = 'null';
            if (Context::getContext()->shop->getContextShopGroupID() != null) {
                $id_shop_group = Context::getContext()->shop->getContextShopGroupID();
            }
            $id_shop = 'null';
            if (Context::getContext()->shop->getContextShopID() != null) {
                $id_shop = Context::getContext()->shop->getContextShopID();
            }

            $order = self::getNewOrderPosition();
            Db::getInstance()->Execute(
                'INSERT INTO `'._DB_PREFIX_.'lineven_rlp`
                (`id_shop_group`, `id_shop`,
                `name`, `short_description`, `comments`,
                `category_id`, `related_product_id`, `related_products_keywords`, 
                `category_products_id`, `product_id`, `products_keywords`, 
                `is_reciprocity`,
                `is_keywords_rules_active`, `is_keywords_rules_reference`, `is_keywords_rules_name`, `is_keywords_rules_description`,
                `hooks`, 
                `order_display`)
                values('.$id_shop_group.', '.$id_shop.',
                \''.addslashes(serialize($fields_values['name'])).'\',
                \''.addslashes(serialize($fields_values['short_description'])).'\',
                \''.addslashes($fields_values['comments']).'\',
                '.$id_related_category.',
                '.$id_related_product.',
                '.$related_keywords.',
                '.$id_category_products.',
                '.$id_product.',
                '.$product_keywords.',
                '.(int)$fields_values['is_reciprocity'].',
                '.(int)$fields_values['is_keywords_rules_active'].',
                '.(int)$is_keywords_rules_reference.',
                '.(int)$is_keywords_rules_name.',
                '.(int)$is_keywords_rules_description.',
                \''.pSQL($which_hooks).'\',
                '.(int)$order.')'
            );
            $id_association = Db::getInstance()->Insert_ID();
        } else {
            // Update
            Db::getInstance()->Execute(
                'UPDATE `'._DB_PREFIX_.'lineven_rlp`
                SET
                `name` = \''.addslashes(serialize($fields_values['name'])).'\',
                `short_description` = \''.addslashes(serialize($fields_values['short_description'])).'\',
                `comments` = \''.addslashes($fields_values['comments']).'\',
                `category_id` = '.$id_related_category.',
                `related_product_id` = '.$id_related_product.',
                `related_products_keywords` = '.$related_keywords.',
                `category_products_id` = '.$id_category_products.',
                `product_id` = '.$id_product.',
                `products_keywords`= '.$product_keywords.',
                `is_reciprocity` = '.(int)$fields_values['is_reciprocity'].',
                `is_keywords_rules_active` = '.(int)$fields_values['is_keywords_rules_active'].',
                `is_keywords_rules_reference` = '.(int)$is_keywords_rules_reference.',
                `is_keywords_rules_name` = '.(int)$is_keywords_rules_name.',
                `is_keywords_rules_description` = '.(int)$is_keywords_rules_description.',
                `hooks` = \''.pSQL($which_hooks).'\'
                WHERE id = '.(int)$id_association
            );
        }
        return $id_association;
    }

    /**
     * Add quickly association.
     * @param int $id_related_product Related id product
     * @param int $id_displayed_product Displayed id product
     * @return boolean
     */
    public static function addQuicklyAssociation($id_related_product, $id_displayed_product)
    {
        $id_association = 0;
        if ((int)$id_related_product != 0 && (int)$id_displayed_product) {
            $id_shop_group = 'null';
            $id_shop_group = 'null';
            if (Context::getContext()->shop->getContextShopGroupID() != null) {
                $id_shop_group = Context::getContext()->shop->getContextShopGroupID();
            }
            $id_shop = 'null';
            if (Context::getContext()->shop->getContextShopID() != null) {
                $id_shop = Context::getContext()->shop->getContextShopID();
            }
            $order = self::getNewOrderPosition();
            Db::getInstance()->Execute(
                'INSERT INTO `'._DB_PREFIX_.'lineven_rlp`
                (`id_shop_group`, `id_shop`,
                `related_product_id`, `product_id`,
                `order_display`)
                values('.$id_shop_group.', '.$id_shop.',
                '.(int)$id_related_product.',
                '.(int)$id_displayed_product.',
                '.(int)$order.')'
            );
            $id_association = Db::getInstance()->Insert_ID();
        }
        return ($id_association != 0 ? true : false);
    }

    /**
     * Delete.
     * @param int|array $ids Id to delete
     * @return boolean
     */
    public static function staticDelete($ids)
    {
        $in = '';
        if (is_array($ids)) {
            if (count($ids)) {
                $in = implode(',', $ids);
            }
        } else {
            $in = (int)$ids;
        }
        if ($in != '') {
            $result = Db::getInstance()->Execute(
                'DELETE FROM `'._DB_PREFIX_.'lineven_rlp` WHERE id in ('.pSQL($in).')'
            );
            self::reorder();
            return $result;
        }
        return true;
    }

    /**
     * Duplicate.
     * @param int $id Id to duplicate
     * @return boolean
     */
    public static function staticDuplicate($id)
    {
        if ($id) {
            Db::getInstance()->Execute(
                'INSERT INTO `'._DB_PREFIX_.'lineven_rlp` (
                 `id_shop_group`, `id_shop`, `name`, `short_description`, `comments`,
                `category_id`, `related_product_id`, `related_products_keywords`, 
                `product_id`, `category_products_id`, `products_keywords`, 
                `is_reciprocity`,
                `is_keywords_rules_active`, `is_keywords_rules_reference`, `is_keywords_rules_name`, `is_keywords_rules_description`,
                `order_display`, `options`
                )
                (SELECT `id_shop_group`, `id_shop`,
                `name`, `short_description`, `comments`,
                `category_id`, `related_product_id`, `related_products_keywords`, 
                `product_id`, `category_products_id`, `products_keywords`, 
                `is_reciprocity`,
                `is_keywords_rules_active`, `is_keywords_rules_reference`, `is_keywords_rules_name`, `is_keywords_rules_description`,
                `order_display`, `options` FROM `'._DB_PREFIX_.'lineven_rlp` WHERE `id` = '.(int)$id.')'
            );
            self::reorder();
        }
    }

    /**
     * Change order fields.
     * @param array $positions Positions
     * @param string $position_first First position
     * @return boolean
     */
    public static function order($positions, $position_first)
    {
        $position = $position_first;
        $positions = explode(',', $positions);
        if (is_array($positions)) {
            foreach ($positions as $id) {
                // Update
                Db::getInstance()->Execute(
                    'UPDATE `'._DB_PREFIX_.'lineven_rlp`
                    SET `order_display` = '.(int)$position.'
                    WHERE id = '.(int)$id
                );
                $position++;
            }
        }
        return true;
    }

    /**
     * Reorder fields.
     * return @void
     */
    public static function reorder()
    {
        $sql = 'SELECT `id`, `order_display` FROM `'._DB_PREFIX_.'lineven_rlp` ORDER BY `order_display` ASC, `id` ASC';
        $rlp_list = Db::getInstance()->ExecuteS($sql);
        $order = 1;
        $count_rlp_list = count($rlp_list);
        for ($i = 0; $i < $count_rlp_list; $i++) {
            Db::getInstance()->Execute(
                'UPDATE `'._DB_PREFIX_.'lineven_rlp`
                SET `order_display` = '.$order.'
                WHERE id = '.(int)$rlp_list[$i]['id']
            );
            $order++;
        }
    }

    /**
     * Get new order position.
     * return @void
     */
    public static function getNewOrderPosition()
    {
        $sql = 'SELECT MAX(`order_display`) `max_order` FROM `'._DB_PREFIX_.'lineven_rlp`';
        $rlp_max_list = Db::getInstance()->ExecuteS($sql);
        $order = 1;
        if (count($rlp_max_list) > 0 && $rlp_max_list[0]['max_order'] != '') {
            $order = $rlp_max_list[0]['max_order'] + 1;
        }
        return $order;
    }

    /**
     * Set rules.
     * @return void
     */
    private function setRules()
    {
        $this->keywords_rules = array();
        if ((int)$this->is_keywords_rules_active == 1) {
            if ((int)$this->is_keywords_rules_reference == 1) {
                $this->keywords_rules[] = 'reference';
            }
            if ((int)$this->is_keywords_rules_name == 1) {
                $this->keywords_rules[] = 'name';
            }
            if ((int)$this->is_keywords_rules_description == 1) {
                $this->keywords_rules[] = 'description';
            }
        }
    }

    /**
     * Get all associations.
     * @return array
     */
    public static function getAssociations()
    {
        $where_shop = '';
        if (Context::getContext()->shop->getContextShopID() != null) {
            $where_shop = ' WHERE `id_shop` = '.(int)Context::getContext()->shop->getContextShopID().' ';
        } else {
            if (Context::getContext()->shop->getContextShopGroupID() != null) {
                $where_shop = ' WHERE `id_shop_group` = '.(int)Context::getContext()->shop->getContextShopGroupID().' ';
            }
        }

        $sql = 'SELECT * FROM `'._DB_PREFIX_.'lineven_rlp` '.$where_shop.' ORDER BY `order_display` ASC, `id` ASC ';
        $rlp_list = Db::getInstance()->ExecuteS($sql);
        return $rlp_list;
    }

    /**
     * Get associations by related product.
     *
     * @param int $id_product Product id
     *
     * @return arrays
     */
    public static function getByRelatedProduct($id_product = null)
    {
        $module_context = LinevenRlpContext::getContext();
        if ($id_product == null) {
            return null;
        }
        $where_shop = '';
        if (Context::getContext()->shop->getContextShopID() != null) {
            $where_shop = ' AND rlp.`id_shop` = '.(int)Context::getContext()->shop->getContextShopID().' ';
        } else {
            if (Context::getContext()->shop->getContextShopGroupID() != null) {
                $where_shop = ' AND rlp.`id_shop_group` = '.(int)Context::getContext()->shop->getContextShopGroupID().' ';
            }
        }
        $sql = 'SELECT rlp.*, g.`name` `shop_group_name`, s.`name` `shop_name`,
            displayed_pl.`name` displayed_product_name, displayed_p.`reference` displayed_product_reference
            FROM `'._DB_PREFIX_.'lineven_rlp` rlp
            LEFT JOIN `'._DB_PREFIX_.'shop_group` g on (rlp.`id_shop_group` = g.`id_shop_group`)
            LEFT JOIN `'._DB_PREFIX_.'shop` s on (rlp.`id_shop` = s.`id_shop`)
            LEFT JOIN `'._DB_PREFIX_.'product` displayed_p ON (rlp.`product_id` = displayed_p.`id_product`)
            LEFT JOIN `'._DB_PREFIX_.'product_lang` displayed_pl ON (rlp.`product_id` = displayed_pl.`id_product`
                AND displayed_pl.`id_lang` = '.(int)$module_context->current_id_lang.Shop::addSqlRestrictionOnLang('displayed_pl').')'.
            ' WHERE rlp.`product_id` is not null AND rlp.`related_product_id` = '.(int)$id_product.$where_shop;
        return Db::getInstance()->ExecuteS($sql);
    }
}
