<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAssociationAdminListingPresenter extends LinevenRlpModuleAdminListingPresenter
{

    /**
     * Present.
     * @param array $datas Datas
     * @return array
     */
    public function presentList($datas)
    {
        $associations = array();
        for ($i = 0; $i < count($datas); $i++) {
            $association = $datas[$i];
            $association['identifier'] = $association['id'];
            $association['name'] = ' : '.$this->translator->l('Association No', 'AssociationAdminListingPresenter').
                ' '.$association['id'];
            $association['selection_rule'] = '';
            if ($association['category_id'] != null) {
                $association['selection_rule'] = $association['related_category_name'];
            }
            if ($association['related_product_id'] != null) {
                $association['selection_rule'] = $association['related_product_name'];
            }
            if ($association['related_products_keywords'] != null) {
                $association['selection_rule'] = $association['related_products_keywords'];
            }
            $association['object_to_display'] = '';
            if ($association['category_products_id'] != null) {
                $association['object_to_display'] = $association['displayed_category_name'];
            }
            if ($association['product_id'] != null) {
                $association['object_to_display'] = $association['displayed_product_name'];
            }
            if ($association['products_keywords'] != null) {
                $association['object_to_display'] = $association['products_keywords'];
            }
            $association['product_new_name'] = $datas[$i]['name'];
            $association['product_new_description'] = $datas[$i]['short_description'];
            $group_shop = $this->translator->l('All shops', 'AssociationAdminListingPresenter');
            if ($association['id_shop'] != null) {
                $group_shop = $association['shop_name'];
            } else {
                if ($association['id_shop_group'] != null) {
                    $group_shop = $association['shop_group_name'];
                }
            }
            $association['group_shop'] = $group_shop;
            $association['class'] = 'lrlp-associations-list-item';
            $type = LinevenRlpAssociation::$related_products_type_all;
            if ($association['category_id'] != '') {
                $type = LinevenRlpAssociation::$related_products_type_category;
            }
            if ($association['related_product_id'] != '') {
                $type = LinevenRlpAssociation::$related_products_type_product;
            }
            if ($association['related_products_keywords'] != '') {
                $type = LinevenRlpAssociation::$related_products_type_keywords;
            }
            $association['association_type'] = $type;
            $display_choice = '';
            if ($association['category_products_id'] != '') {
                $display_choice = LinevenRlpAssociation::$related_display_category;
            }
            if ($association['product_id'] != '') {
                $display_choice = LinevenRlpAssociation::$related_display_product;
            }
            if ($association['products_keywords'] != '') {
                $display_choice = LinevenRlpAssociation::$related_display_keywords;
            }
            $association['display_choice'] = $display_choice;
            $association['options'] = '';
            $associations[] = $association;
        }
        return $associations;
    }

    /**
     * Present for product.
     * @param array $datas Datas
     * @return array
     */
    public function presentListForProduct($datas)
    {
        $associations = array();
        if (count($datas)) {
            for ($i = 0; $i < count($datas); $i++) {
                $association = $datas[$i];
                $association['identifier'] = $datas[$i]['id'];
                $group_shop = $this->translator->l('All shops', 'Lists');
                if ($datas[$i]['id_shop'] != null) {
                    $group_shop = $datas[$i]['shop_name'];
                } else {
                    if ($datas[$i]['id_shop_group'] != null) {
                        $group_shop = $datas[$i]['shop_group_name'];
                    }
                }
                $association['group_shop'] = $group_shop;
                $associations[] = $association;
            }
        }
        return $associations;
    }

    /**
     * Get html for selection rules to display in associations list.
     * @param string $selection_value Selection value
     * @param array $row Row
     * @return string
     */
    public static function getHtmlSelectionRule($selection_value, $row)
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        $translator = new LinevenRlpTranslator();
        if ($row['association_type'] == LinevenRlpAssociation::$related_products_type_product) {
            if ($row['related_product_id'] != null && (int)$row['related_product_id']) {
                $product_cover = Product::getCover($row['related_product_id']);
                return self::getHtmlProductsInformations(
                    $row['related_product_id'],
                    $selection_value,
                    $row['related_product_reference'],
                    $product_cover
                );
            }
        }
        // If other text display via smarty
        $simple_text = null;
        if ($row['association_type'] == LinevenRlpAssociation::$related_products_type_all) {
            $simple_text = array(
                'span_class' => 'lrlp-associations-list-text',
                'text' => $translator->l('(systematically displayed)', 'AssociationAdminListingPresenter')
            );
        }
        if ($row['association_type'] == LinevenRlpAssociation::$related_products_type_category) {
            $simple_text = array(
                'icon' => array(
                    'span_class' => 'lrlp-associations-list-icon imgm img-thumbnail',
                    'i_class' => 'fa fa-folder-open-o fa-2x'
                ),
                'text' => $selection_value
            );
        }
        if ($row['association_type'] == LinevenRlpAssociation::$related_products_type_keywords) {
            $simple_text = array(
                'icon' => array(
                    'span_class' => 'lrlp-associations-list-icon imgm img-thumbnail',
                    'i_class' => 'fa fa-search fa-2x'
                ),
                'text' => $selection_value
            );
        }
        Context::getContext()->smarty->assign('helper_listing_text', $simple_text);
        return $configuration->getModule()->display(
            _PS_MODULE_DIR_.$configuration->getModule()->name,
            'views/templates/admin/module/_partials/helpers/list/simple_text.tpl'
        );
    }

    /**
     * Get html for object to display in associations list.
     * @param string $object_to_display Object to display
     * @param array $row Row
     * @return string
     */
    public static function getHtmlObjectToDisplay($object_to_display, $row)
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        if ($row['display_choice'] == LinevenRlpAssociation::$related_display_product) {
            if (isset($row['product_id']) && $row['product_id'] != null && (int)$row['product_id']) {
                $product_cover = Product::getCover($row['product_id']);
                return self::getHtmlProductsInformations(
                    $row['product_id'],
                    $object_to_display,
                    $row['displayed_product_reference'],
                    $product_cover
                );
            }
        }
        if ($row['display_choice'] == LinevenRlpAssociation::$related_display_category) {
            $simple_text = array(
                'icon' => array(
                    'span_class' => 'lrlp-associations-list-icon imgm img-thumbnail',
                    'i_class' => 'fa fa-folder-open-o fa-2x'
                ),
                'text' => $object_to_display
            );
        }
        if ($row['display_choice'] == LinevenRlpAssociation::$related_display_keywords) {
            $simple_text = array(
                'icon' => array(
                    'span_class' => 'lrlp-associations-list-icon imgm img-thumbnail',
                    'i_class' => 'fa fa-search fa-2x'
                ),
                'text' => $object_to_display
            );
        }
        Context::getContext()->smarty->assign('helper_listing_text', $simple_text);
        return $configuration->getModule()->display(
            _PS_MODULE_DIR_.$configuration->getModule()->name,
            'views/templates/admin/module/_partials/helpers/list/simple_text.tpl'
        );
    }

    /**
     * Get html for product to display in associations list.
     *
     * @param int $product_id
     * @param string $product_name Product name
     * @param string $product_reference Product reference
     * @param object $product_cover Product cover
     * @return string
     */
    public static function getHtmlProductsInformations($product_id, $product_name, $product_reference, $product_cover)
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        $image_html = '';
        if ($product_cover != null) {
            $imageManager = new PrestaShop\PrestaShop\Adapter\ImageManager(new PrestaShop\PrestaShop\Adapter\LegacyContext());
            $image_html = $imageManager->getThumbnailForListing((int)$product_cover['id_image']);
        }
        Context::getContext()->smarty->assign(array(
            'product_thumbnail' => $image_html,
            'product_name' => $product_name,
            'product_reference' => $product_reference,
        ));
        return $configuration->getModule()->display(
            _PS_MODULE_DIR_.$configuration->getModule()->name,
            'views/templates/admin/module/helpers/product_informations.tpl'
        );
    }

    /**
     * Get html options in associations list.
     * @param string $options Object to display
     * @param array $row Row
     * @return string
     */
    public static function getHtmlOptions($options, $row)
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        $module_context = LinevenRlpContext::getContext();
        $smarty_options = array();
        if ($row['is_reciprocity']) {
            $smarty_options[] = 'fa-exchange fa-2x';
        }
        if ($row['is_keywords_rules_active']) {
            $smarty_options[] = 'fa-search-plus fa-2x';
        }
        if (isset($row['hooks']) && $row['hooks'] != '') {
            $smarty_options[] = 'fa-link fa-2x';
        }
        $name = unserialize($row['product_new_name']);
        $description = unserialize($row['product_new_description']);
        if ((is_array($name) && count($name) && $name[$module_context->default_id_lang] && trim($name[$module_context->default_id_lang]) != '')
            || (is_array($description) && count($description) && $description[$module_context->default_id_lang] && trim($description[$module_context->default_id_lang]) != '')) {
            $smarty_options[] = 'fa-info fa-2x';
        }
        if ($row['comments'] && trim($row['comments']) != '') {
            $smarty_options[] = 'fa-comment-o fa-2x';
        }
        Context::getContext()->smarty->assign('helper_listing_options', $smarty_options);
        return $configuration->getModule()->display(
            _PS_MODULE_DIR_.$configuration->getModule()->name,
            'views/templates/admin/module/_partials/helpers/list/options_icons.tpl'
        );
    }

    /**
     * Get fields.
     */
    public function getFields()
    {
        $fields_description = array(
            'id' => array(
                'title' => $this->translator->l('Id.', 'AssociationAdminListingPresenter'),
                'type' => 'int',
                'align' => 'center',
                'class' => 'lineven-helper-list-identifier',
                'orderby' => true,
                'search' => true,
                'value' => ''
            ),
            'selection_rule' => array(
                'title' => $this->translator->l('Selection rule', 'AssociationAdminListingPresenter'),
                'type' => 'text',
                'render' => 'specific',
                'callback' => 'getHtmlSelectionRule',
                'callback_object' => 'LinevenRlpAssociationAdminListingPresenter',
                'filter_clause' => 'having',
                'orderby' => true,
                'search' => true,
                'value' => ''
            ),
            'object_to_display' => array(
                'title' => $this->translator->l('Display', 'AssociationAdminListingPresenter'),
                'type' => 'text',
                'render' => 'specific',
                'callback' => 'getHtmlObjectToDisplay',
                'callback_object' => 'LinevenRlpAssociationAdminListingPresenter',
                'filter_clause' => 'having',
                'orderby' => true,
                'search' => true,
                'value' => ''
            ),
            'options' => array(
                'title' => $this->translator->l('Options', 'AssociationAdminListingPresenter'),
                'type' => 'text',
                'render' => 'specific',
                'callback' => 'getHtmlOptions',
                'callback_object' => 'LinevenRlpAssociationAdminListingPresenter',
                'orderby' => false,
                'search' => false,
                'value' => ''
            )
        );
        if (Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE') !== false
            && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE') == 1
            && Shop::getTotalShops() > 1) {
            $fields_description['group_shop'] = array(
                'title' => $this->translator->l('Group / Shop', 'AssociationAdminListingPresenter'),
                'type' => 'text',
                'orderby' => false
            );
        }
        $fields_description['order_display'] = array(
            'title' => $this->translator->l('Position', 'AssociationAdminListingPresenter'),
            'class' => 'lineven-helper-list-position',
            'type' => 'int',
            'align' => 'center',
            'orderby' => true,
            'search' => true,
            'value' => ''
        );
        return $fields_description;
    }
}
