<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAssociationAdminListingSearch extends LinevenRlpModuleAdminListingSearch
{
    /**
     * Run query.
     *
     * @param array $settings Settings
     * @return array
     */
    public function runQuery(
        $settings
    ) {
        $this->results = $this->getAssociations($settings, false);
        $this->count = $this->getAssociations($settings, true);
        return $this->results;
    }

    /**
     * Get associations.
     *
     * @param array $settings Settings
     * @param boolean $for_count For count
     *
     * @return array
     */
    public function getAssociations(
        $settings,
        $for_count = false
    ) {
        $module_context = LinevenRlpContext::getContext();
        $where_shop = '';
        if (Context::getContext()->shop->getContextShopID() != null) {
            $where_shop = ' rlp.`id_shop` = '.(int)Context::getContext()->shop->getContextShopID().' ';
        } else {
            if (Context::getContext()->shop->getContextShopGroupID() != null) {
                $where_shop = ' rlp.`id_shop_group` = '.(int)Context::getContext()->shop->getContextShopGroupID().' ';
            }
        }
        $sql = 'SELECT rlp.*, g.`name` `shop_group_name`, s.`name` `shop_name`,
            related_cl.`name` related_category_name,
            related_pl.`name` related_product_name, related_p.`reference` related_product_reference,
            (CASE 
                WHEN rlp.`category_id` IS NOT NULL THEN related_cl.`name`
                WHEN rlp.`related_product_id` IS NOT NULL THEN related_pl.`name`
                WHEN rlp.`related_products_keywords` IS NOT NULL THEN rlp.`related_products_keywords`
                ELSE ""
            END) AS selection_rule,
            displayed_cl.`name` displayed_category_name,
            displayed_pl.`name` displayed_product_name, displayed_p.`reference` displayed_product_reference,
            (CASE 
                WHEN rlp.`category_products_id` IS NOT NULL THEN displayed_cl.`name`
                WHEN rlp.`product_id` IS NOT NULL THEN displayed_pl.`name`
                WHEN rlp.`products_keywords` IS NOT NULL THEN rlp.`products_keywords`
                ELSE ""
            END) AS object_to_display
            FROM `'._DB_PREFIX_.'lineven_rlp` rlp
            LEFT JOIN `'._DB_PREFIX_.'shop_group` g on (rlp.`id_shop_group` = g.`id_shop_group`)
            LEFT JOIN `'._DB_PREFIX_.'shop` s on (rlp.`id_shop` = s.`id_shop`)
            LEFT JOIN `'._DB_PREFIX_.'category_lang` related_cl ON (rlp.`category_id` = related_cl.`id_category`'.Shop::addSqlRestrictionOnLang('related_cl').'
                AND related_cl.`id_lang` = '.(int)$module_context->current_id_lang.Shop::addSqlAssociation('category_lang', 'related_cl').')
            LEFT JOIN `'._DB_PREFIX_.'product` related_p ON (rlp.`related_product_id` = related_p.`id_product`)
               LEFT JOIN `'._DB_PREFIX_.'product_lang` related_pl ON (rlp.`related_product_id` = related_pl.`id_product`
                AND related_pl.`id_lang` = '.(int)$module_context->current_id_lang.Shop::addSqlRestrictionOnLang('related_pl').')
            LEFT JOIN `'._DB_PREFIX_.'category_lang` displayed_cl ON (rlp.`category_products_id` = displayed_cl.`id_category`'.Shop::addSqlRestrictionOnLang('displayed_cl').'
                AND displayed_cl.`id_lang` = '.(int)$module_context->current_id_lang.Shop::addSqlAssociation('category_lang', 'displayed_cl').')
            LEFT JOIN `'._DB_PREFIX_.'product` displayed_p ON (rlp.`product_id` = displayed_p.`id_product`)
            LEFT JOIN `'._DB_PREFIX_.'product_lang` displayed_pl ON (rlp.`product_id` = displayed_pl.`id_product`
                AND displayed_pl.`id_lang` = '.(int)$module_context->current_id_lang.Shop::addSqlRestrictionOnLang('displayed_pl').')'.
            LinevenRlpHelperList::addSqlFiltering($settings, !$for_count, $where_shop);
        $rlp_list = Db::getInstance()->ExecuteS($sql);
        if ($for_count) {
            return count($rlp_list);
        }
        return $rlp_list;
    }
}
