<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFormAdminAssociation extends LinevenRlpForm
{
    /**
     * Init.
     * @return void
     */
    public function init()
    {
        $module_context = LinevenRlpContext::getContext();
        // Categories
        $categories = Category::getCategories($module_context->current_id_lang, true, false);
        $categories_select = array();
        foreach ($categories as $category) {
            $categories_select[] = array(
                'id' => $category['id_category'],
                'name' => $category['name'].' ('.$category['id_category'].')'
            );
        };
        
        $this->fields['association_type'] = array(
            'form' => array(
                'legend' => array(
                        'title' => $this->translator->l('Association type', 'Association'),
                        'icon' => 'fa fa-chain'
                    ),
                'description' =>
                    $this->translator->l('You can select products display rules.', 'Association'),
                'input' => array(
                    array(
                        'type' => 'hidden',
                        'name' => 'id'
                    ),
                    array(
                        'type' => 'hidden',
                        'name' => 'related_product_id',
                    ),
                    array(
                        'type' => 'hidden',
                        'name' => 'product_id',
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->translator->l('Association type', 'Association'),
                        'name' => 'association_type',
                        'options' => array(
                            'query' => array(
                                array(
                                    'id' => LinevenRlpAssociation::$related_products_type_all,
                                    'name' => $this->translator->l('Systematic', 'Association')
                                ),
                                array(
                                    'id' => LinevenRlpAssociation::$related_products_type_category,
                                    'name' => $this->translator->l('For category', 'Association')
                                ),
                                array(
                                    'id' => LinevenRlpAssociation::$related_products_type_product,
                                    'name' => $this->translator->l('For a specific product', 'Association')
                                ),
                                array(
                                    'id' => LinevenRlpAssociation::$related_products_type_keywords,
                                    'name' => $this->translator->l('By products keywords', 'Association')
                                )
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->translator->l('Your display choice', 'Association'),
                        'name' => 'display_choice',
                        'options' => array(
                            'query' => array(
                                array(
                                    'id' => LinevenRlpAssociation::$related_display_product,
                                    'name' => $this->translator->l('A product', 'Association')
                                ),
                                array(
                                    'id' => LinevenRlpAssociation::$related_display_category,
                                    'name' => $this->translator->l('Products by category', 'Association')
                                ),
                                array(
                                    'id' => LinevenRlpAssociation::$related_display_keywords,
                                    'name' => $this->translator->l('Products by keywords', 'Association')
                                )
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    )
                )
            ),
        );
        $this->fields['selection_rule_category'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Selection rules', 'Association'),
                    'icon' => 'fa fa-folder-open-o'
                ),
                'description' => $this->translator->l('If products belongs to the selected category, the product will be displayed to the customer.', 'Association'),
                'input' => array(
                    array(
                        'type' => 'select',
                        'label' => $this->translator->l('Category', 'Association'),
                        'name' => 'category_id',
                        'options' => array(
                            'query' => $categories_select,
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'class' => 'chosen fixed-width-xxl'
                    )
                )
            ),
        );
        $this->fields['selection_rule_keywords'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Selection rules', 'Association'),
                    'icon' => 'fa fa-i-cursor'
                ),
                'description_multilines' => array(
                    $this->translator->l('If products which contains keywords are selected by the customer,', 'Association').' '.
                        $this->translator->l('the product will be displayed to the customer.', 'Association'),
                    $this->translator->l('Warning, keyword search requires more resources for the module.', 'Association')
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->translator->l('By products keywords', 'Association'),
                        'name' => 'related_products_keywords',
                        'maxlength' => 255,
                        'desc' => array(
                            $this->translator->l('Syntax 1 : ipod ipad -nano => ipod OR ipad BUT NOT nano.', 'Association'),
                            $this->translator->l('Syntax 2 : ipod ipad +nano => (ipod OR ipad) AND nano.', 'Association')
                        ),
                    )
                )
            ),
        );
        $this->fields['display_category'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Products to display', 'Association'),
                    'icon' => 'fa fa-folder-open-o'
                ),
                'description' => $this->translator->l('Select the category to display all products in.', 'Association'),
                'input' => array(
                    array(
                        'type' => 'select',
                        'label' => $this->translator->l('Category', 'Association'),
                        'name' => 'category_products_id',
                        'options' => array(
                            'query' => $categories_select,
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'class' => 'chosen fixed-width-xxl'
                    )
                )
            ),
        );
        $this->fields['display_keywords'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Products to display', 'Association'),
                    'icon' => 'fa fa-i-cursor'
                ),
                'description_multilines' => array(
                    $this->translator->l('The products which contains keywords will be displayed to the customer.', 'Association'),
                    $this->translator->l('Warning, keyword search requires more resources for the module.', 'Association')
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->translator->l('Products keywords', 'Association'),
                        'name' => 'products_keywords',
                        'maxlength' => 255,
                        'desc' =>  array(
                            $this->translator->l('Syntax 1 : ipod ipad -nano => ipod OR ipad BUT NOT nano.', 'Association'),
                            $this->translator->l('Syntax 2 : ipod ipad +nano => (ipod OR ipad) AND nano.', 'Association')
                        )
                    )
                )
            ),
        );
        $this->fields['which_hooks'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Hooks restrictions', 'Association'),
                    'icon' => 'fa fa-link'
                ),
                'description_multilines' => array(
                    $this->translator->l('Choose the hooks you want to authorize for this association.', 'Association'),
                    $this->translator->l('No selection or all selected values ​​equals "all hooks will be used"', 'Association')
                ),
                'input' => array(
                    array(
                        'type' => 'group',
                        'label' => $this->translator->l('Hooks', 'Association'),
                        'name' => 'which_hooks',
                        'specific' => true,
                        'subtype' => 'which_hooks',
                        'value' => array(),
                        'values' => array(
                            array(
                                'id_group' => RelatedProducts::$hook_code_homepage,
                                'name' => $this->translator->l('Homepage', 'Association'),
                                'val' => RelatedProducts::$hook_code_homepage
                            ),
                            array(
                                'id_group' => RelatedProducts::$hook_code_column,
                                'name' => $this->translator->l('Column', 'Association'),
                                'val' => RelatedProducts::$hook_code_column
                            ),
                            array(
                                'id_group' => RelatedProducts::$hook_code_product,
                                'name' => $this->translator->l('Product page', 'Association'),
                                'val' => RelatedProducts::$hook_code_product
                            ),
                            array(
                                'id_group' => RelatedProducts::$hook_code_quickview,
                                'name' => $this->translator->l('Product quick view', 'Association'),
                                'val' => RelatedProducts::$hook_code_quickview
                            ),
                            array(
                                'id_group' => RelatedProducts::$hook_code_order,
                                'name' => $this->translator->l('Order page', 'Association'),
                                'val' => RelatedProducts::$hook_code_order
                            ),
                            array(
                                'id_group' => RelatedProducts::$hook_code_ajaxcart,
                                'name' => $this->translator->l('Ajax cart', 'Association'),
                                'val' => RelatedProducts::$hook_code_ajaxcart
                            )
                        ),
                        'desc' =>$this->translator->l('No selection or all selected values ​​equals "all hooks will be used"', 'Association')
                    )
                )
            ),
        );
        $this->fields['reciprocity'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Reciprocity between products', 'Association'),
                    'icon' => 'fa fa-exchange'
                ),
                'input' => array(
                    array(
                        'type' => 'checkbox',
                        'name' => 'is_reciprocity',
                        'values' => array(
                            'query' => array(
                                array(
                                    'id' => 'on',
                                    'name' => $this->translator->l('Active products reciprocity.', 'Association'),
                                    'val' => '1'
                                ),
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    )
                )
            ),
        );
        
        $this->fields['specifics_rules'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('For associations by keywords', 'Association'),
                    'icon' => 'fa fa-search',
                ),
                'description' =>
                    $this->translator->l('By default, for associations, default keywords rules are used.', 'Association').' '.
                    $this->translator->l('You can change rules only for this association.', 'Association'),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Activate specific keywords', 'Association'),
                        'name' => 'is_keywords_rules_active',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'is_keywords_rules_active_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'Association')
                            ),
                            array(
                                'id' => 'is_keywords_rules_active_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'Association')
                            )
                        )
                    ),
                    array(
                        'type' => 'group',
                        'label' => $this->translator->l('What informations would you use for keywords associations ?', 'Association'),
                        'name' => 'keywords_rules',
                        'specific' => true,
                        'subtype' => 'keywords_rules',
                        'value' => array(),
                        'values' => array(
                            array(
                                'id_group' => RelatedProducts::$rules_keywords_reference,
                                'name' => $this->translator->l('Product reference', 'Association'),
                                'val' => RelatedProducts::$rules_keywords_reference
                            ),
                            array(
                                'id_group' => RelatedProducts::$rules_keywords_name,
                                'name' => $this->translator->l('Product name', 'Association'),
                                'val' => RelatedProducts::$rules_keywords_name
                            ),
                            array(
                                'id_group' => RelatedProducts::$rules_keywords_description,
                                'name' => $this->translator->l('Product description', 'Association'),
                                'val' => RelatedProducts::$rules_keywords_description
                            )
                        )
                    )
                )
            ),
        );
        $this->fields['description'] = array(
            'form' => array(
                'legend' => array(
                        'title' => $this->translator->l('Product name & description', 'Association'),
                        'icon' => 'fa fa-info'
                    ),
                'description_multilines' => array(
                    $this->translator->l('You can set a title and / or description for the product to display on the order page.', 'Association'),
                    $this->translator->l('By default, the title and product description are taken.', 'Association')
                ),
                'input' => array(
                   array(
                        'type' => 'text',
                        'label' => $this->translator->l('Product name', 'Association'),
                        'name' => 'name',
                        'maxlength' => 255,
                        'lang' => true,
                        'desc' => $this->translator->l('By default, product name used. You can set an alternative name to use for each languages.', 'Association')
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->translator->l('Description', 'Association'),
                        'name' => 'short_description',
                        'rows' => 5,
                        'cols' => 60,
                        'lang' => true,
                        'desc' => $this->translator->l('By default, product short description used.', 'Association').' '.
                            $this->translator->l('You can set an alternative description to use for each languages.', 'Association'),
                    )
                )
            ),
        );
        $this->fields['comments'] = array(
            'form' => array(
                'legend' => array(
                        'title' => $this->translator->l('Comments', 'Association'),
                        'icon' => 'fa fa-comment-o'
                    ),
                'description' => $this->translator->l('The comment is for your own use only.', 'Association'),
                'input' => array(
                    array(
                        'type' => 'textarea',
                        'label' => $this->translator->l('Comments', 'Association'),
                        'name' => 'comments',
                        'rows' => 5,
                        'cols' => 60
                    )
                )
            ),
        );
        $this->setElements($this->fields['association_type']['form']['input']);
        $this->setElements($this->fields['selection_rule_category']['form']['input']);
        $this->setElements($this->fields['selection_rule_keywords']['form']['input']);
        $this->setElements($this->fields['display_category']['form']['input']);
        $this->setElements($this->fields['display_keywords']['form']['input']);
        $this->setElements($this->fields['which_hooks']['form']['input']);
        $this->setElements($this->fields['reciprocity']['form']['input']);
        $this->setElements($this->fields['specifics_rules']['form']['input']);
        $this->setElements($this->fields['description']['form']['input']);
        $this->setElements($this->fields['comments']['form']['input']);
    }

    /**
     * Validate.
     * @return boolean
     */
    public function validate()
    {
        $languages = Language::getLanguages(true);
        if (Tools::getValue('association_type') == LinevenRlpAssociation::$related_products_type_product) {
            if (!Tools::isSubmit('related_product_id') ||(Tools::isSubmit('related_product_id') &&
                (Tools::getValue('related_product_id') == '' || Tools::getValue('related_product_id') == 0))) {
                $this->addError($this->translator->l('You must fill a correct product for the selection rule.', 'Association'));
            }
        }
        if (Tools::getValue('association_type') == LinevenRlpAssociation::$related_products_type_keywords) {
            if (!Tools::isSubmit('related_products_keywords') ||(Tools::isSubmit('related_products_keywords') &&
                Tools::strlen(trim(Tools::getValue('related_products_keywords'))) == 0)) {
                $this->addError($this->translator->l('You must fill related products keywords.', 'Association'));
            }
            if (Tools::strlen(Tools::getValue('related_products_keywords')) > 255) {
                $this->addError(
                    $this->translator->l('Related products keywords are too long (max 255 characters).', 'Association')
                );
            }
        }
        if (Tools::getValue('display_choice') == LinevenRlpAssociation::$related_display_product) {
            if (!Tools::isSubmit('product_id') ||(Tools::isSubmit('product_id') &&
                (Tools::getValue('product_id') == '' || Tools::getValue('product_id') == 0))) {
                $this->addError($this->translator->l('You must fill a correct product to display.', 'Association'));
            }
        }
        if (Tools::getValue('display_choice') == LinevenRlpAssociation::$related_display_keywords) {
            if (!Tools::isSubmit('products_keywords') ||(Tools::isSubmit('products_keywords') &&
                Tools::strlen(trim(Tools::getValue('products_keywords'))) == 0)) {
                $this->addError($this->translator->l('You must fill products keywords.', 'Association'));
            }
            if (Tools::strlen(Tools::getValue('products_keywords')) > 255) {
                $this->addError(
                    $this->translator->l('Products keywords are too long (max 255 characters).', 'Association')
                );
            }
        }
        // Check for each language
        foreach ($languages as $language) {
            $language_name = $language['name'];
            if (Tools::strlen(Tools::getValue('name_'.$language['id_lang'])) > 255) {
                $this->addError(
                    $this->translator->l('The product name is too long for the language:', 'Association').' '.$language_name.'.'
                );
            }
            if (Tools::strlen(trim(Tools::getValue('short_description_'.$language['id_lang']))) > 4000) {
                $this->addError(
                    $this->translator->l('The product description is too long for the language:', 'Association').' '.$language_name.'.'
                );
            }
        }
        
        return parent::validate();
    }

    /**
     * Populate.
     *
     * @param Object $object
     * @return void
     */
    public function populate($object)
    {
        parent::populate($object);

        // Populate options
        if ($object != null && property_exists(get_class($object), 'hooks') && $object->hooks != '') {
            $values = explode('|', $object->hooks);
            foreach ($values as $value) {
                $this->setValue('which_hooks_'.$value, 1);
            }
            $this->setValue('which_hooks', $values);
        }
    }
}
