<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFormAdminAssociationRules extends LinevenRlpForm
{
    /**
     * Init.
     * @return void
     */
    public function init()
    {
        $this->fields[0] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('For the selection rules', 'AssociationsRules'),
                    'icon' => 'fa fa-compress',
                ),
                'description' => $this->translator->l('Choose cart, orders and/or viewed products for the selection rules to use by associations.', 'AssociationsRules'),
                'input' => array(
                    array(
                        'type' => 'checkbox',
                        'name' => 'include_products_cart',
                        'configuration_name' => 'LINEVEN_RLP_INCLUDE_CART',
                        'values' => array(
                            'query' => array(
                                array(
                                    'id' => 'on',
                                    'name' => $this->translator->l('Use cart to select products to display.', 'AssociationsRules'),
                                    'val' => '1'
                                ),
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        ),
                    ),
                    array(
                        'type' => 'checkbox',
                        'name' => 'include_products_order',
                        'configuration_name' => 'LINEVEN_RLP_INCLUDE_ORDERS',
                        'values' => array(
                            'query' => array(
                                array(
                                    'id' => 'on',
                                    'name' => $this->translator->l('Use customers orders to select products to display (identified customers only).', 'AssociationsRules'),
                                    'val' => '1'
                                ),
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        ),
                    ),
                    array(
                        'type' => 'checkbox',
                        'name' => 'include_products_viewed',
                        'configuration_name' => 'LINEVEN_RLP_INCLUDE_VIEWED',
                        'values' => array(
                            'query' => array(
                                array(
                                    'id' => 'on',
                                    'name' => $this->translator->l('Use viewed products to select products to display.', 'AssociationsRules'),
                                    'val' => '1'
                                ),
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'desc' => $this->translator->l('A product viewed by the customer will not be displayed again.', 'AssociationsRules'),
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'text_info_1',
                        'specific' => 'alert',
                        'alert_type' => 'warning',
                        'html_content' => array(
                            $this->translator->l('To store products already seen, the module store ids products in a cookie session.', 'AssociationsRules'),
                            $this->translator->l('The cookie is used for the rule "Use viewed products to select products to display" and for the plugin "Products already seen".', 'AssociationsRules'),
                            $this->translator->l('You can set the maximum ids products to store in the cookie.', 'AssociationsRules')
                        )
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->translator->l('Maximum products to store in cookie', 'AssociationsRules'),
                        'name' => 'max_products_in_cookie',
                        'configuration_name' => 'LINEVEN_RLP_COOKIE_PVIEWED_MAX',
                        'required' => true,
                        'class' => 'fixed-width-xs',
                        'maxlength' => 2,
                        'hint' => $this->translator->l('This value is required and must be numeric and greater than 0.', 'AssociationsRules'),
                        'desc' => $this->translator->l('Maximum product to store in cookie.', 'AssociationsRules')
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'AssociationsRules'),
                )
            ),
        );
        $product_keywords_value = unserialize(Configuration::get('LINEVEN_RLP_KW_RULES_DFLT'));
        $this->fields[1] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('For associations by keywords', 'AssociationsRules'),
                    'icon' => 'fa fa-search',
                ),
                'description' => $this->translator->l('By default, for your associations, choose products informations to use for search by keywords.', 'AssociationsRules'),
                'input' => array(
                    array(
                        'type' => 'group',
                        'label' => $this->translator->l('What informations would you use for keywords associations ?', 'AssociationsRules'),
                        'name' => 'rules_keywords_products',
                        'specific' => true,
                        'subtype' => 'rules',
                        'value' => $product_keywords_value,
                        'values' => array(
                            array(
                                'id_group' => 'name',
                                'name' => $this->translator->l('Product name', 'AssociationsRules'),
                                'val' => 'name'
                            ),
                            array(
                                'id_group' => 'description',
                                'name' => $this->translator->l('Product description', 'AssociationsRules'),
                                'val' => 'description'
                            ),
                            array(
                                'id_group' => 'reference',
                                'name' => $this->translator->l('Product reference', 'AssociationsRules'),
                                'val' => 'reference'
                            )
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'AssociationsRules'),
                )
            ),
        );
    }

    /**
     * Validate.
     * @return boolean
     */
    public function validate()
    {
        if (Tools::strlen(trim(Tools::getValue('max_products_in_cookie'))) == 0
            || !Validate::isInt(Tools::getValue('max_products_in_cookie'))
            || (int)Tools::getValue('max_products_in_cookie') <= 0) {
            $this->addError(
                $this->translator->l('You must fill a correct maximum products to store in cookie.', 'AssociationsRules')
            );
        }
        return parent::validate();
    }

    /**
     * Update settings
     *
     * @return void
     */
    public function updateSettings()
    {
        parent::updateSettings();
        $values = array();
        if (Tools::isSubmit('rules_keywords_products')) {
            $values = Tools::getValue('rules_keywords_products');
        }
        Configuration::updateValue('LINEVEN_RLP_KW_RULES_DFLT', serialize($values));
    }
}
