<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFormAdminOnAjaxCart extends LinevenRlpFormAdminOnHookForm
{
    /**
     * Constructor.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct('OAC', 'ajaxcart');
    }

    /**
     * Init.
     * @return void
     */
    public function init()
    {
        $this->fields['activation'] = array(
            'form' => array(
            'legend' => array(
                    'title' => $this->translator->l('Activation', 'OnAjaxCart'),
                    'icon' => 'fa fa-bolt'
                ),
                'description' => $this->translator->l('Be careful : To use ajax cart you must modify your theme template page to include the specific hook :', 'OnAjaxCart').
                    ' '.LinevenRlpTools::displayHtmlInCode('simple_tag', array(
                        'tag' => 'strong',
                        'text' => '{hook h=\'displayRelatedProductsAjaxCart\'}'
                    )),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Display in ajax cart', 'OnAjaxCart'),
                        'name' => 'active_hook',
                        'configuration_name' => 'LINEVEN_RLP_HOOK_AJAXCART',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_hook_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'OnAjaxCart')
                            ),
                            array(
                                'id' => 'active_hook_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'OnAjaxCart')
                            )
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'OnAjaxCart'),
                )
            ),
        );

        // Render one section only settings
        $this->renderOneSectionSettingsFieldset();

        // Render display settings
        $this->renderDisplaySettingsFieldset();

        // Render plugins definitions
        $this->renderPluginsFieldset();

        // Render sort settings
        $this->renderSortSettingsFieldset();
    }

    /**
     * Validate.
     * @return boolean
     */
    public function validate()
    {
        return parent::validate();
    }
}
