<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFormAdminOnColumn extends LinevenRlpFormAdminOnHookForm
{
    /**
     * Constructor.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct('OCL', 'column');
    }


    /**
     * Init.
     * @return void
     */
    public function init()
    {
        $this->fields['activation'] = array(
            'form' => array(
            'legend' => array(
                    'title' => $this->translator->l('Activation', 'OnColumn'),
                    'icon' => 'fa fa-bolt'
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Display in column', 'OnColumn'),
                        'name' => 'active_hook',
                        'configuration_name' => 'LINEVEN_RLP_HOOK_COLUMN',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_hook_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'OnColumn')
                            ),
                            array(
                                'id' => 'active_hook_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'OnColumn')
                            )
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'OnColumn'),
                )
            ),
        );

        // Render asynchronous settings settings
        $this->renderAsynchronousSettingsFieldset();

        // Render one section only settings
        $this->renderOneSectionSettingsFieldset();

        // Render display settings
        $this->renderDisplaySettingsFieldset(
            false,
            false,
            array(
                array(
                    'type' => 'select',
                    'label' => $this->translator->l('Column to use', 'OnColumn'),
                    'name' => 'column_witch',
                    'configuration_name' => 'LINEVEN_RLP_OCL_WITCH',
                    'options' => array(
                        'query' => array(
                            array(
                                'id' => RelatedProducts::$displaying_column_left,
                                'name' => $this->translator->l('on left column', 'OnColumn')
                            ),
                            array(
                                'id' => RelatedProducts::$displaying_column_right,
                                'name' => $this->translator->l('on right column', 'OnColumn')
                            )
                        ),
                        'id' => 'id',
                        'name' => 'name'
                    ),
                    'desc' => array(
                        $this->translator->l('Select the theme column to display the products block.', 'OnColumn'),
                        $this->translator->l('Be careful, some themes do not permit right or/and left columns.', 'OnColumn')
                    ),
                )
            )
        );

        // Render plugins definitions
        $this->renderPluginsFieldset();

        // Render sort settings
        $this->renderSortSettingsFieldset();
    }

    /**
     * Validate.
     * @return boolean
     */
    public function validate()
    {
        return parent::validate();
    }
}
