<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFormAdminOnHomePage extends LinevenRlpFormAdminOnHookForm
{

    /**
     * Constructor.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct('OHP', 'home');
    }


    /**
     * Init.
     * @return void
     */
    public function init()
    {
        $this->fields['activation'] = array(
            'form' => array(
            'legend' => array(
                    'title' => $this->translator->l('Activation', 'OnHomePage'),
                    'icon' => 'fa fa-bolt'
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Display on homepage', 'OnHomePage'),
                        'name' => 'active_hook',
                        'configuration_name' => 'LINEVEN_RLP_HOOK_HOME',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_hook_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'OnHomePage')
                            ),
                            array(
                                'id' => 'active_hook_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'OnHomePage')
                            )
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'OnHomePage'),
                )
            ),
        );

        // Render asynchronous settings settings
        $this->renderAsynchronousSettingsFieldset();

        // Render one section only settings
        $this->renderOneSectionSettingsFieldset();

        // Render display settings
        $this->renderDisplaySettingsFieldset();

        // Render plugins definitions
        $this->renderPluginsFieldset();

        // Render sort settings
        $this->renderSortSettingsFieldset();
    }

    /**
     * Validate.
     * @return boolean
     */
    public function validate()
    {
        return parent::validate();
    }
}
