<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFormAdminOnOrderPage extends LinevenRlpFormAdminOnHookForm
{

    /**
     * Constructor.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct('OOP', 'shoppingcart', 'ShoppingCart');
    }

    /**
     * Init.
     * @return void
     */
    public function init()
    {
        $this->fields['activation'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Activation', 'OnOrderPage'),
                    'icon' => 'fa fa-bolt'
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Display in order page', 'OnOrderPage'),
                        'name' => 'active_hook',
                        'configuration_name' => 'LINEVEN_RLP_HOOK_SHOPPINGCART',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_hook_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'OnOrderPage')
                            ),
                            array(
                                'id' => 'active_hook_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'OnOrderPage')
                            )
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'OnOrderPage'),
                )
            ),
        );

        // Render hook to use
        $this->renderHookToUseFieldset(
            array(
                $this->translator->l('Choose the hook on the order page to display products.', 'OnOrderPage'),
                $this->translator->l('The module use the Prestashop standard hooks : ', 'OnOrderPage'),
                ' - '.$this->translator->l('Shopping cart footer', 'OnProductPage').' (displayShoppingCartFooter)',
                '',
                $this->translator->l('You can configure the module to use a specific hook implemented in your theme (and so not recognized by the module).', 'OnOrderPage'),
            ),
            array(
                array(
                    'id' => RelatedProducts::$shoppingcart_page_hook_use_footer ,
                    'name' => $this->translator->l('Shopping cart footer', 'OnOrderPage')
                ),
                array(
                    'id' => RelatedProducts::$hook_to_use_specific,
                    'name' => $this->translator->l('A specific hook', 'OnOrderPage')
                )
            )
        );

        // Render asynchronous settings settings
        $this->renderAsynchronousSettingsFieldset();

        $this->fields['refresh'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Refresh settings', 'OnOrderPage'),
                    'icon' => 'fa fa-refresh'
                ),
                'description_multilines' => array(
                    $this->translator->l('When your customer changes their cart directly into the order page, you can refresh the products according to the characteristics of your theme among:', 'OnOrderPage'),
                    ' - '.$this->translator->l('No action needed because your theme refreshes your page.', 'OnOrderPage'),
                    ' - '.$this->translator->l('Forcing the refresh of your page by the module (with a configurable delay).', 'OnOrderPage'),
                    ' - '.$this->translator->l('Only refresh the display section of the module (with a configurable delay). Be careful, this method may not work depending on the specificities of the themes or module on this page.', 'OnOrderPage')
                ),
                'input' => array(
                    array(
                        'type' => 'select',
                        'label' => $this->translator->l('Refresh method', 'OnOrderPage'),
                        'name' => 'refresh_method',
                        'configuration_name' => 'LINEVEN_RLP_OOP_REFRESH_MODE',
                        'options' => array(
                            'query' => array(
                                array(
                                    'id' => RelatedProducts::$refresh_method_nothing,
                                    'name' => $this->translator->l('Do nothing', 'OnOrderPage')
                                ),
                                array(
                                    'id' => RelatedProducts::$refresh_method_reload,
                                    'name' => $this->translator->l('Reload the page', 'OnOrderPage')
                                ),
                                array(
                                    'id' => RelatedProducts::$refresh_method_ajax,
                                    'name' => $this->translator->l('Only refresh the section', 'OnOrderPage')
                                )
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'desc' => $this->translator->l('Choose the most suitable method for your theme and module in this page.', 'OnOrderPage'),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->translator->l('Delay before refresh', 'OnOrderPage'),
                        'name' => 'refresh_delay',
                        'configuration_name' => 'LINEVEN_RLP_OOP_REFRESH_DELAY',
                        'required' => true,
                        'suffix' => $this->translator->l('milliseconds', 'OnOrderPage'),
                        'class' => 'fixed-width-md',
                        'maxlength' => 5,
                        'hint' => $this->translator->l('This value is required and must be numeric.', 'OnOrderPage'),
                        'desc' => $this->translator->l('Set to 0 for an imediate refresh.', 'OnOrderPage')
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'OnOrderPage'),
                )
            ),
        );

        // Render section activation
        $this->renderSectionActivationFieldset();

        // Render display settings
        $this->renderDisplaySettingsFieldset();

        // Render plugins definitions
        $this->renderPluginsFieldset();

        // Render sort settings
        $this->renderSortSettingsFieldset();
    }
    
    /**
     * Validate.
     * @return boolean
     */
    public function validate()
    {
        if (Tools::strlen(trim(Tools::getValue('refresh_delay'))) == 0
            || !Validate::isInt(Tools::getValue('refresh_delay'))) {
            $this->addError(
                $this->translator->l('You must fill a correct delay for refresh.', 'OnOrderPage')
            );
        }
        return parent::validate();
    }
}
