<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFormAdminOnProductPage extends LinevenRlpFormAdminOnHookForm
{

    /**
     * Constructor.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct('OPP', 'productpage', 'ProductPage');
    }
    
    /**
     * Init.
     * @return void
     */
    public function init()
    {
        $this->fields['activation'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Activation', 'OnProductPage'),
                    'icon' => 'fa fa-bolt'
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Display on product page', 'OnProductPage'),
                        'name' => 'active_hook',
                        'configuration_name' => 'LINEVEN_RLP_HOOK_PRODUCTFOOTER',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_hook_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'OnProductPage')
                            ),
                            array(
                                'id' => 'active_hook_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'OnProductPage')
                            )
                        )
                    ),
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'OnProductPage'),
                )
            ),
        );

        // Render hook to use
        $this->renderHookToUseFieldset(
            array(
                $this->translator->l('Choose the hook on the product page to display products.', 'OnProductPage'),
                $this->translator->l('The module use the Prestashop standard hooks : ', 'OnProductPage'),
                ' - '.$this->translator->l('Product footer', 'OnProductPage').' (displayFooterProduct)',
                ' - '.$this->translator->l('Product tab', 'OnProductPage').' (displayProductExtraContent)',
                '',
                $this->translator->l('You can configure the module to use a specific hook implemented in your theme (and so not recognized by the module).', 'OnProductPage'),
            ),
            array(
                array(
                    'id' => RelatedProducts::$product_page_hook_use_footer,
                    'name' => $this->translator->l('Product footer', 'OnProductPage')
                ),
                array(
                    'id' => RelatedProducts::$product_page_hook_use_tab,
                    'name' => $this->translator->l('Product tab (only for compatible themes)', 'OnProductPage')
                ),
                array(
                    'id' => RelatedProducts::$hook_to_use_specific,
                    'name' => $this->translator->l('A specific hook', 'OnProductPage')
                )
            )
        );

        // Render asynchronous settings settings
        $this->renderAsynchronousSettingsFieldset();

        // Render section activation
        $this->renderSectionActivationFieldset(
            array(
                '',
                $this->translator->l('Separate display could not work correctly in tab mode according themes.', 'OnProductPage')
            )
        );

        // Render display settings
        $this->renderDisplaySettingsFieldset();

        // Render plugins definitions
        $this->renderPluginsFieldset();

        // Render sort settings
        $this->renderSortSettingsFieldset();
    }

    /**
     * Validate.
     * @return boolean
     */
    public function validate()
    {
        return parent::validate();
    }

    /**
     * Update settings
     *
     * @return void
     */
    public function updateSettings()
    {
        parent::updateSettings();
    }
}
