<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFormAdminOnQuickView extends LinevenRlpFormAdminOnHookForm
{

    /**
     * Constructor.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct('OQV', 'quickview');
    }

    /**
     * Init.
     * @return void
     */
    public function init()
    {
        $this->fields['activation'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Activation', 'OnQuickView'),
                    'icon' => 'fa fa-bolt'
                ),
                'description' => (version_compare(_PS_VERSION_, '1.7.1.0', '<')
                        ? $this->translator->l('Be careful : To use quick view product you must modify your theme template page to include the specific hook :', 'OnQuickView')
                        : $this->translator->l('To display products in the quick view, the module use the Prestashop standard hook "displayProductAdditionalInfo".', 'OnQuickView').
                            '<br/>'.$this->translator->l('If your theme do not implement this hook for the product quick view, you must modify your theme template page to include the specific hook :', 'OnQuickView'))
                        .'<br/>'.LinevenRlpTools::displayHtmlInCode('simple_tag', array(
                            'tag' => 'strong',
                            'text' => '{hook h=\'displayRelatedProductsQuickView\'}')).'.',

                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Display on product quick view', 'OnQuickView'),
                        'name' => 'active_hook',
                        'configuration_name' => 'LINEVEN_RLP_HOOK_QUICKVIEW',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_hook_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'OnQuickView')
                            ),
                            array(
                                'id' => 'active_hook_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'OnQuickView')
                            )
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'OnQuickView'),
                )
            ),
        );

        // Render one section only settings
        $this->renderOneSectionSettingsFieldset();

        // Render display settings
        $this->renderDisplaySettingsFieldset();

        // Render plugins definitions
        $this->renderPluginsFieldset();

        // Render sort settings
        $this->renderSortSettingsFieldset();
    }
    
    /**
     * Validate.
     * @return boolean
     */
    public function validate()
    {
        return parent::validate();
    }
}
