<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFormAdminPluginOptions extends LinevenRlpForm
{
    private $plugin;              // Plugin
    private $plugin_class;        // Plugin class

    /**
     * LinevenRlpFormAdminPluginSettings constructor.
     * @param object $plugin Plugin
     * @param object $plugin_class Plugin class
     */
    public function __construct($plugin, $plugin_class)
    {
        $this->plugin = $plugin;
        $this->plugin_class = $plugin_class;
        parent::__construct();
    }

    /**
     * Init.
     * @return void
     */
    public function init()
    {
        if ($this->plugin_class != null) {
            $admin_plugin_options = $this->plugin_class->getAdminFormOptions();
            foreach ($admin_plugin_options as &$option) {
                $option['name'] = $this->plugin->id_plugin.'_'.$option['name'];
            }
            if ($admin_plugin_options) {
                array_unshift(
                    $admin_plugin_options,
                    array(
                        'type' => 'html',
                        'html_content' => '',
                        'name' => 'html_content_start_plugin_options',
                    )
                );
                array_push(
                    $admin_plugin_options,
                    array(
                        'type' => 'html',
                        'html_content' => '',
                        'name' => 'html_content_end_plugin_options',
                    )
                );
                $this->fields['options'] = array(
                    'form' => array(
                        'input' => $admin_plugin_options,
                    )
                );
            }
        }
    }

    /**
     * Populate options.
     *
     * @return void
     */
    public function populateOptions($plugin_options)
    {
        if ($this->plugin_class != null) {
            if ($this->plugin_class->hasOptions() && $plugin_options != null) {
                foreach ($plugin_options as $option_name => $option_value) {
                    if ($this->plugin->hasOption($option_name)) {
                        if (!isset($plugin_options[$option_name])) {
                            $option_value = $this->plugin->getOption($option_name);
                        }
                        $this->setValue($this->plugin->id_plugin.'_'.$option_name, $option_value);
                    }
                }
            }
        }
    }
}
