<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFormAdminSettings extends LinevenRlpForm
{

    /**
     * Init.
     * @return void
     */
    public function init()
    {
        $this->fields['activation'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Activation', 'Settings'),
                    'icon' => 'fa fa-bolt'
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Activate module', 'Settings'),
                        'name' => 'active_module',
                        'configuration_name' => 'LINEVEN_RLP_ACTIVE',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_module_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'Settings')
                            ),
                            array(
                                'id' => 'active_module_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'Settings')
                            )
                        )
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Activate associations by keywords', 'Settings'),
                        'name' => 'active_keywords_associations',
                        'configuration_name' => 'LINEVEN_RLP_ACTIVE_ASSOC_KW',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_module_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'Settings')
                            ),
                            array(
                                'id' => 'active_module_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'Settings')
                            )
                        ),
                        'desc' => array(
                            $this->translator->l('Associations by keyword requires more resources for the module.', 'Settings'),
                            $this->translator->l('You can disable this feature with this setting.', 'Settings')
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'Settings'),
                )
            ),
        );
        $this->fields['backoffice_menu'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('In the backoffice menu', 'Settings'),
                    'icon' => 'fa fa-bars'
                ),
                'description' => $this->translator->l('You can activate the backoffice menu to manage your products without passing through the module.', 'Settings'),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Activate backoffice menu', 'Settings'),
                        'name' => 'active_bo_menu',
                        'configuration_name' => 'LINEVEN_RLP_ACTIVE_BO_MENU',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_bo_menu_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'Settings')
                            ),
                            array(
                                'id' => 'active_bo_menu_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'Settings')
                            ),
                        ),
                        'desc' =>
                        $this->translator->l('You can manage products in "Catalog > Related Products".', 'Settings')
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'Settings'),
                )
            ),
        );
        $this->fields['admin_product'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('In product catalog', 'Settings'),
                    'icon' => 'fa fa-tag'
                ),
                'description' => $this->translator->l('You can define associations directly in your product page of your catalog', 'Settings'),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->translator->l('Activate for catalog product page', 'Settings'),
                        'name' => 'active_bo_adm_product',
                        'configuration_name' => 'LINEVEN_RLP_ACTIVE_BO_ADM_PRD',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_bo_adm_product_on',
                                'value' => 1,
                                'label' => $this->translator->l('Yes', 'Settings')
                            ),
                            array(
                                'id' => 'active_bo_adm_product_off',
                                'value' => 0,
                                'label' => $this->translator->l('No', 'Settings')
                            ),
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'Settings'),
                )
            ),
        );
        $this->fields['preferences'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->translator->l('Preferences', 'Settings'),
                    'icon' => 'fa fa-eye'
                ),
                'description' => $this->translator->l('You can set preferences for module administration.', 'Settings'),
                'input' => array(
                    array(
                        'type' => 'checkbox',
                        'name' => 'bo_list_filter',
                        'configuration_name' => 'LINEVEN_RLP_BO_LIST_FILTER',
                        'values' => array(
                            'query' => array(
                                array(
                                    'id' => 'on',
                                    'name' => $this->translator->l('Show filters in associations list.', 'Settings'),
                                    'val' => '1'
                                ),
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->translator->l('Save', 'Settings'),
                )
            ),
        );
    }

    /**
     * Update settings
     *
     * @return void
     */
    public function updateSettings()
    {
        parent::updateSettings();
        // Admin tab management
        if (Tools::isSubmit('active_bo_menu')) {
            LinevenRlpTabs::manage(
                Tools::getValue('active_bo_menu')
            );
        }
    }
}
