<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPlugin
{
    protected $plugin_options = array();    // Plugin options
    protected $admin_listing_description;   // Admin description for lists
    protected $admin_form_description;      // Admin description for form
    protected $id_column_name = 'id_product';
    protected $is_related_products_must_verified = true;

    /**
     * Set plugin options.
     * @param array $options Options
     */
    public function setPluginOptions($options)
    {
        $this->plugin_options = array_merge(
            $this->plugin_options,
            $options
        );
    }

    /**
     * Get plugin options.
     * @return array
     */
    public function getPluginOptions()
    {
        return $this->plugin_options;
    }

    /**
     * Has plugin options.
     * @return boolean
     */
    public function hasOptions()
    {
        return (count($this->plugin_options) ? true : false);
    }

    /**
     * Get plugin option.
     * @param string $name Name
     * @return mixed
     */
    public function getPluginOption($name)
    {
        if (isset($this->plugin_options[$name])) {
            return $this->plugin_options[$name];
        }
        return false;
    }

    /**
     * Get admin description for lists.
     * @return string
     */
    public function getAdminListingDescription()
    {
        return $this->admin_listing_description;
    }

    /**
     * Get admin description for form.
     * @return string
     */
    public function getAdminFormDescription()
    {
        return $this->admin_form_description;
    }

    /**
     * Get product id column name.
     * @return string
     */
    public function getProductIdColumnName()
    {
        return $this->id_column_name;
    }

    /**
     * Is related product must verified for this plugin.
     * @return bool
     */
    public function isRelatedProductsMustVerified()
    {
        return $this->is_related_products_must_verified;
    }

    /**
     * Get admin form options.
     */
    public function getAdminFormOptions()
    {
        return array();
    }
}
