<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginAdminListingPresenter extends LinevenRlpModuleAdminListingPresenter
{

    /**
     * Present.
     * @param array $datas Datas
     * @return array
     */
    public function presentList($datas)
    {
        for ($i = 0; $i < count($datas); $i++) {
            $datas[$i]['identifier'] = $datas[$i]['id_plugin'];
            $datas[$i]['name'] = LinevenRlpTranslator::getTranslationFromArray(
                unserialize($datas[$i]['name'])
            );
            $class_object = LinevenRlpPluginObject::getStaticClass($datas[$i]['classname']);
            if ($class_object != null) {
                $datas[$i]['admin_informations'] = $class_object->getAdminListingDescription();
            } else {
                $datas[$i]['admin_informations'] = $this->translator->l('No file found for this class.', 'PluginAdminListingPresenter');
            }
            if ($datas[$i]['type'] == LinevenRlpPluginObject::$plugin_type_system) {
                $datas[$i]['classname'] = '';
            }
            $datas[$i]['class'] = 'lrlp-plugins-list-item';
        }
        return $datas;
    }

    /**
     * Get fields.
     */
    public function getFields()
    {
        $fields_description = array(
            'id_plugin' => array(
                'title' => $this->translator->l('Id.', 'PluginAdminListingPresenter'),
                'type' => 'int',
                'align' => 'center',
                'class' => 'lineven-helper-list-identifier',
                'value' => ''
            ),
            'name' => array(
                'title' => $this->translator->l('Name', 'PluginAdminListingPresenter'),
                'type' => 'text',
                'value' => ''
            ),
            'is_active' => array(
                'title' => $this->translator->l('Status', 'PopupAdminListingPresenter'),
                'active' => 'activation_plugin_',
                'type' => 'bool',
                'align' => 'center',
                'value' => ''
            ),
            'admin_informations' => array(
                'title' => $this->translator->l('Informations', 'PluginAdminListingPresenter'),
                'type' => 'text',
                'value' => ''
            ),
            'classname' => array(
                'title' => $this->translator->l('Classname', 'PluginAdminListingPresenter'),
                'type' => 'text',
                'value' => ''
            ),
            'order_display' => array(
                'title' => $this->translator->l('Position', 'PluginAdminListingPresenter'),
                'class' => 'lineven-helper-list-position',
                'type' => 'int',
                'align' => 'center',
                'orderby' => true,
                'search' => true,
                'value' => ''
            )
        );
        return $fields_description;
    }
}
