<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginAdminListingSearch extends LinevenRlpModuleAdminListingSearch
{
    /**
     * Run query.
     *
     * @param array $settings Settings
     * @return array
     */
    public function runQuery(
        $settings
    ) {
        $this->results = $this->getPlugins($settings, false);
        $this->count = $this->getPlugins($settings, true);
        return $this->results;
    }

    /**
     * Get plugins.
     *
     * @param array $settings Settings
     * @param boolean $for_count For count
     *
     * @return array
     */
    public function getPlugins(
        $settings,
        $for_count = false
    ) {
        $sql = 'SELECT plg.*
            FROM `'._DB_PREFIX_.'lineven_rlp_plugins` plg'.
            LinevenRlpHelperList::addSqlFiltering($settings, !$for_count);
        $plugin_list = Db::getInstance()->ExecuteS($sql);
        if ($for_count) {
            return count($plugin_list);
        }
        return $plugin_list;
    }
}
