<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginAdminOnHookFormPresenter extends LinevenRlpModuleAdminFormPresenter
{
    private $hook_code;             // Hook code
    private $plugins_to_use;        // Plugins to use
    private $id_plugin;             // Plugin id
    private $plugin_code;           // Plugin code

    /**
     * Constructor.
     * @param string $hook_code Hook code
     * @return void
     */
    public function __construct($hook_code = '')
    {
        parent::__construct();
        $this->hook_code = $hook_code;
        $this->plugins_to_use = array();
        $this->id_plugin = null;
        $this->plugin_code = null;
    }

    /**
     * Set plugins to used.
     * @param array $plugin_to_use PLugin_to_use
     * @return void
     */
    public function setPluginsToUse($plugin_to_use = null)
    {
        if ($plugin_to_use == null) {
            $plugin_to_use = LinevenRlpPluginObject::getPlugins();
        }
        foreach ($plugin_to_use as $plugin) {
            $this->plugins_to_use[$plugin['code']] = array(
                'id' => $plugin['id_plugin'],
                'name' => LinevenRlpPluginObject::getStaticDisplayedName(unserialize($plugin['name']))
            );
        }
    }

    /**
     * Set plugin to used.
     * @param int $id_plugin Plugin id
     * @return void
     */
    public function setPluginToUse($id_plugin)
    {
        // Get plugin
        $plugin = new LinevenRlpPluginObject($id_plugin);
        $this->id_plugin = $id_plugin;
        $this->plugin_code = $plugin->code;
        if ($plugin) {
            $this->plugins_to_use[$plugin->code]= array(
                'id' => $plugin->id_plugin,
                'name' => $plugin->getDisplayedName()
            );
        }
    }
    /**
     * Present used plugins list.
     */
    public function presentUsedPluginsList()
    {
        $form_presenter = parent::present();

        $form_presenter['plugins'] = $this->plugins_to_use;
        $form_presenter['plugins_used'] = $this->getUsedPlugins();
        return $form_presenter;
    }

    /**
     * Present specific plugin.
     */
    public function presentPlugin()
    {
        $form_presenter = parent::present();

        $plugin_used = array($this->plugin_code => array(
            'max_products' => 5,
            'options' => array()
        ));
        $plugin_used[$this->plugin_code] = array_merge(
            $plugin_used[$this->plugin_code],
            $this->getUsedPlugin($this->id_plugin, $plugin_used[$this->plugin_code])
        );
        $form_presenter['plugins'] = $this->plugins_to_use;
        $form_presenter['plugin_used_key'] = $this->plugin_code;
        $form_presenter['plugin_used'] = $plugin_used[$this->plugin_code];
        return $form_presenter;
    }

    /**
     * Get used plugins.
     * @return array
     */
    public function getUsedPlugins()
    {
        if ($this->plugins_to_use) {
            $plugins_used = array();
            if (Configuration::get('LINEVEN_RLP_'.$this->hook_code.'_PLUGINS') !== false &&
                Configuration::get('LINEVEN_RLP_'.$this->hook_code.'_PLUGINS') != null) {
                $plugins_used = unserialize(Configuration::get('LINEVEN_RLP_' . $this->hook_code . '_PLUGINS'));
            }
            if (count($plugins_used)) {
                foreach ($plugins_used as $plugin_code => $plugin_details) {
                    if (array_key_exists($plugin_code, $this->plugins_to_use)) {
                        $plugin_options = $plugins_used[$plugin_code];
                        if (!is_array($plugin_details)) {
                            // In case of compatibility for previous version
                            $plugin_details = array(
                                'max_products' => (int)$plugin_details,
                                'options' => array()
                            );
                            $plugins_used[$plugin_code] = $plugin_details;
                        }
                        $plugins_used[$plugin_code] = array_merge(
                            $plugin_details,
                            $this->getUsedPlugin(
                                $this->plugins_to_use[$plugin_code]['id'],
                                $plugin_details
                            )
                        );
                    } else {
                        unset($plugins_used[$plugin_code]);
                    }
                }
            }
            return $plugins_used;
        }
        return array();
    }

    /**
     * Get used plugin.
     * @param int $id_plugin Plugin id.
     * @param array $plugin_details Plugin details.
     */
    private function getUsedPlugin($id_plugin, $plugin_details)
    {
        $plugin_used = array();
        $plugin_object = new LinevenRlpPluginObject($id_plugin);
        $plugin_class = $plugin_object->getClass();
        $plugin_used['id'] = $id_plugin;
        $plugin_used['object'] = $plugin_class;
        $plugin_used['options_form'] = null;
        if ($plugin_class->hasOptions()) {
            $controller = LinevenRlpController::getController('Hooks', LinevenRlpController::$controller_type_module);
            $controller->params['id_plugin'] = $plugin_used['id'];
            $controller->params['plugin_object'] = $plugin_object;
            $controller->params['plugin_class'] = $plugin_class;
            $controller->params['plugin_options'] = array();
            if ($plugin_object->hasOptions()) {
                $plugin_options = $plugin_object->getOptions();
                if (isset($plugin_details['options']) && count($plugin_details['options'])) {
                    $plugin_options = $plugin_details['options'];
                }
                $controller->params['plugin_options'] = $plugin_options;
                $pattern = "#<\s*?plugin_options_code\b[^>]*>(.*?)</plugin_options_code\b[^>]*>#s";
                preg_match($pattern, $controller->run('getPluginOptions'), $matches);
                $plugin_used['options_form'] = $matches[1];
            }
        }
        return $plugin_used;
    }
}
