<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemAccessories extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{
    /**
     * LinevenRlpPluginSystemAccessories constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Suggest accessories configured for each product in the catalog.', 'PluginSystemAccessories');
        $this->admin_form_description = array(
            $translator->l('This plugin allow you to suggest accessories configured for each product in the catalog.', 'PluginSystemAccessories'),
            $translator->l('Products accessories are declared for products in your catalog.', 'PluginSystemAccessories')
        );
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        if (count($query->getRelatedProducts())) {
            $sql = 'SELECT p.`id_product`
            FROM `'._DB_PREFIX_.'accessory`
            LEFT JOIN `'._DB_PREFIX_.'product` p ON (p.`id_product` = `id_product_2`)
            '.Shop::addSqlAssociation('product', 'p').'
            WHERE `id_product_1` in ('.pSQL($query->getRelatedProductsSqlIds()).')
            AND p.`id_product` NOT IN ('.pSQL($query->getRelatedProductsSqlIds()).')
            AND product_shop.`id_shop` = '.(int)$context->getIdShop().'
            AND product_shop.`active` = 1
            AND product_shop.`available_for_order` = 1
            AND product_shop.`visibility` IN ('.$context->getVisibilitiesSql().')
             '.($query->isRandomSearch() ? 'ORDER BY RAND()' : '').'
            LIMIT '.(int)$query->getLimit();
            return Db::getInstance()->executeS($sql);
        }
        return array();
    }
}
