<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemAlreadySeen extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{
    /**
     * LinevenRlpPluginSystemAlreadySeen constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Display products already seen.', 'PluginSystemAlreadySeen');
        $this->admin_form_description = $translator->l('This plugin allow you to always display products already seen by the customer.', 'PluginSystemAlreadySeen');
        $this->is_related_products_must_verified = false;
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        $lineven_cookie = new Cookie('lineven_cookie', '', 0);
        $products = array();
        if ($lineven_cookie->exists()) {
            if (isset($lineven_cookie->related_product_viewed) && $lineven_cookie->related_product_viewed != '') {
                $products_viewed = explode(',', $lineven_cookie->related_product_viewed);
                if ($query->isRandomSearch()) {
                    shuffle($products_viewed);
                }
                if (is_array($products_viewed) && count($products_viewed)) {
                    foreach ($products_viewed as $id_product) {
                        $products[] = array('id_product' => $id_product);
                    }
                }
            }
        }
        return $products;
    }
}
