<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemAlsoBought extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{
    /**
     * LinevenRlpPluginSystemAlsoBought constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Customers who bought this product also bought...', 'PluginSystemAlsoBought');
        $this->admin_form_description = $translator->l('This plugin allow you to display "Customers who bought this product also bought..."', 'PluginSystemAlsoBought');
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        if (count($query->getRelatedProducts())) {
            $q_orders = 'SELECT o.id_order
              FROM '._DB_PREFIX_.'orders o
                LEFT JOIN '._DB_PREFIX_.'order_detail od ON (od.id_order = o.id_order)
                WHERE o.valid = 1
                AND od.product_id IN ('.$query->getRelatedProductsSqlIds().')';
            $orders = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($q_orders);
            if (0 < count($orders)) {
                $list = '';
                foreach ($orders as $order) {
                    $list .= (int)$order['id_order'] . ',';
                }
                $list = rtrim($list, ',');
                $sql = 'SELECT DISTINCT od.product_id as id_product
                FROM ' . _DB_PREFIX_ . 'order_detail od
                LEFT JOIN ' . _DB_PREFIX_ . 'product p ON (p.id_product = od.product_id)
                ' . Shop::addSqlAssociation('product', 'p') . '
                WHERE od.id_order IN (' . $list . ')
                AND od.`product_id` NOT IN ('.pSQL($query->getRelatedProductsSqlIds()).')
                AND product_shop.active = 1
                AND product_shop.`available_for_order` = 1
                '.($query->isRandomSearch() ? 'ORDER BY RAND()' : '').'
                LIMIT ' . (int)$query->getLimit();
                return  Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
            }
        }
        return array();
    }
}
