<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemAssociations extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{
    private $context;
    private $query;
    private $products_displayed;

    /**
     * LinevenRlpPluginSystemAssociations constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Used associations defined to display products.', 'PluginSystemAssociations');
        $this->admin_form_description = $translator->l('This plugin allow you to display products according associations you defined in the dedicated menu.', 'PluginSystemAssociations');
        $this->products_displayed = array();
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        $this->context = $context;
        $this->query = $query;

        // Where shop
        $where_shop = 'WHERE ((rlp.`id_shop_group` is null and rlp.`id_shop` is null) or ';
        $where_shop .= '(rlp.`id_shop_group` = '.(int)Context::getContext()->shop->getContextShopGroupID().' 
                        and rlp.`id_shop` is null) or ';
        $where_shop .= '(rlp.`id_shop` = '.Context::getContext()->shop->getContextShopID().'))';

        $related_keywords_sql = '';
        if (Configuration::get('LINEVEN_RLP_ACTIVE_ASSOC_KW')) {
            $related_keywords_sql = $this->getSqlRelatedProductsKeywords();
        }
        $sql = '
            SELECT DISTINCT
                `name`, `short_description`, `options`,
                `related_products_keywords`,
                display_cat_prd.`id_product` as `display_category_product_id`,
                `product_id` as `display_product_id`,
                `products_keywords`,
                `is_keywords_rules_active`,
                `is_keywords_rules_reference`,
                `is_keywords_rules_name`,
                `is_keywords_rules_description`,
                `order_display`
            FROM `'._DB_PREFIX_.'lineven_rlp` rlp
            LEFT JOIN `'._DB_PREFIX_.'category_product` rlp_cat ON (rlp_cat.`id_category` = rlp.`category_id`)
            LEFT JOIN `'._DB_PREFIX_.'category_shop` as rlp_cat_shop ON (rlp_cat.`id_category` = rlp_cat_shop.`id_category` AND rlp_cat_shop.`id_shop` = '.$context->getIdShop().')
            LEFT JOIN `'._DB_PREFIX_.'category_product` display_cat_prd ON (display_cat_prd.`id_category` = rlp.`category_products_id`)
            LEFT JOIN `'._DB_PREFIX_.'category_shop` as display_cat_prd_shop ON (display_cat_prd.`id_category` = display_cat_prd_shop.`id_category` AND display_cat_prd_shop.`id_shop` = '.$context->getIdShop().') '.
            $where_shop.
            ' AND (NULLIF(rlp.`hooks`, \'\') IS NULL OR rlp.`hooks` LIKE (\'%'.$this->query->getHook().'%\')) '.
            (!Configuration::get('LINEVEN_RLP_ACTIVE_ASSOC_KW')
                ? ' AND `products_keywords` is null '
                : '').
            ' AND (
                (
                    rlp.`category_id` is null AND rlp.`related_product_id` is null AND `related_products_keywords` is null
                )'.($related_keywords_sql != ''
                ? ' OR (
                            `related_products_keywords` is not null AND
                            rlp.`id` in ('.$related_keywords_sql.')
                    )'
                : '').
            ($query->getRelatedProductsSqlIds() != ''
                ? 'OR (
                        rlp.`category_id` is not null AND
                        rlp_cat.`id_product` in ('.$query->getRelatedProductsSqlIds().')
                    ) OR (
                        rlp.`related_product_id` is not null AND
                        rlp.`related_product_id` in ('.$query->getRelatedProductsSqlIds().')
                    )'
                : '').'
                ) '.
            (($query->getRelatedProductsSqlIds() != '')
                ? 'UNION
                        SELECT DISTINCT
                        `name`, `short_description`, `options`,
                        `related_products_keywords`,
                        null as `display_category_product_id`,
                        `related_product_id` as `display_product_id`, `products_keywords`,
                        `is_keywords_rules_active`,
                        `is_keywords_rules_reference`,
                        `is_keywords_rules_name`,
                        `is_keywords_rules_description`,
                        `order_display`
                        FROM `'._DB_PREFIX_.'lineven_rlp` rlp '.
                        $where_shop.'  AND (NULLIF(rlp.`hooks`, \'\') IS NULL OR rlp.`hooks` LIKE (\'%'.$this->query->getHook().'%\')) 
                        AND rlp.`is_reciprocity` = 1 AND rlp.`related_product_id` is not null AND rlp.`product_id` is not null
                        AND rlp.`product_id` in ('.$query->getRelatedProductsSqlIds().')'
                : ' ').'
            ORDER BY `order_display` ASC';
        $rlp_list = Db::getInstance()->ExecuteS($sql);

        // If related products created
        if (count($rlp_list) > 0) {
            // Randomize
            if ($query->isRandomPlugins()) {
                shuffle($rlp_list);
            }
            for ($i = 0; $i < count($rlp_list); $i++) {
                if ($rlp_list[$i]['products_keywords'] == '') {
                    $id_product_to_display = $rlp_list[$i]['display_product_id'];
                    if ($rlp_list[$i]['display_category_product_id'] != '') {
                        $id_product_to_display = $rlp_list[$i]['display_category_product_id'];
                    }
                    $this->addProductDisplayed($id_product_to_display, $rlp_list[$i]);
                } else {
                    $this->searchProductsByKeywords($rlp_list[$i]);
                }
                if (count($this->products_displayed) >= $query->getLimit()) {
                    break;
                }
            }
        }
        return $this->products_displayed;
    }

    /**
     * Get sql for related products by keywords.
     * @return string sql
     */
    private function getSqlRelatedProductsKeywords()
    {
        $selected_associations = array();
        if ($this->query->getRelatedProductsSqlIds() != '') {
            // Where shop
            $where_shop = 'WHERE ((rlp.`id_shop_group` is null and rlp.`id_shop` is null) or ';
            $where_shop .= '(rlp.`id_shop_group` = '.(int)Context::getContext()->shop->getContextShopGroupID().'
                            and rlp.`id_shop` is null) or ';
            $where_shop .= '(rlp.`id_shop` = '.(int)Context::getContext()->shop->getContextShopID().'))';

            // Search if related products keywords are defined
            $sql = 'SELECT DISTINCT `id`, `related_products_keywords`,
                `is_keywords_rules_active`, `is_keywords_rules_reference`,
                `is_keywords_rules_name`, `is_keywords_rules_description`
                FROM `'._DB_PREFIX_.'lineven_rlp` rlp '.
                $where_shop.' AND `related_products_keywords` IS NOT NULL ';

            $rlp_list = Db::getInstance()->executeS($sql);
            if (count($rlp_list)) {
                // Get related products details
                $sql = 'SELECT p.`reference`, pl.`name`, pl.`description`, pl.`description_short`
                    FROM `'._DB_PREFIX_.'product` p
                    '.Shop::addSqlAssociation('product', 'p').'
                    LEFT JOIN `'._DB_PREFIX_.'product_lang` pl
                        ON (p.`id_product` = pl.`id_product`
                        AND pl.`id_lang` = '.(int)$this->context->getIdLang().Shop::addSqlRestrictionOnLang('pl').')
                    WHERE product_shop.`id_shop` = '.(int)Context::getContext()->shop->getContextShopID().'
                        AND product_shop.`active` = 1
                        AND p.`id_product` in ( '.$this->query->getRelatedProductsSqlIds().')';
                $products_list = Db::getInstance()->executeS($sql);
                if (count($products_list)) {
                    $search_by_default = unserialize(Configuration::get('LINEVEN_RLP_KW_RULES_DFLT'));
                    // Default input string
                    $input_string = '';
                    // For each related products
                    for ($j = 0; $j < count($products_list); $j++) {
                        if (in_array('name', $search_by_default)) {
                            $input_string .= ' '.$products_list[$j]['name'];
                        }
                        if (in_array('description', $search_by_default)) {
                            $input_string .= ' '.$products_list[$j]['description'];
                        }
                        if (in_array('reference', $search_by_default)) {
                            $input_string .= ' '.$products_list[$j]['reference'];
                        }
                        if ($input_string == '') {
                            $input_string = ' '.$products_list[$j]['name'];
                        }
                    }
                    // For each keywords associations
                    for ($i = 0; $i < count($rlp_list); $i++) {
                        $query = explode(' ', trim($rlp_list[$i]['related_products_keywords']));
                        $search_by = $search_by_default;
                        if (isset($rlp_list[$i]['is_keywords_rules_active']) && $rlp_list[$i]['is_keywords_rules_active']) {
                            $search_by = array(
                                'reference' => $rlp_list[$i]['is_keywords_rules_reference'],
                                'name' => $rlp_list[$i]['is_keywords_rules_name'],
                                'description' => $rlp_list[$i]['is_keywords_rules_description']
                            );
                            // Specific input string
                            $input_string = '';
                            // For each related products
                            for ($j = 0; $j < count($products_list); $j++) {
                                if (isset($search_by['name']) && $search_by['name'] == 1) {
                                    $input_string .= ' '.$products_list[$j]['name'];
                                }
                                if (isset($search_by['description']) && $search_by['description'] == 1) {
                                    $input_string .= ' '.$products_list[$j]['description'];
                                }
                                if (isset($search_by['reference']) && $search_by['reference'] == 1) {
                                    $input_string .= ' '.$products_list[$j]['reference'];
                                }
                                if ($input_string == '') {
                                    $input_string = ' '.$products_list[$j]['name'];
                                }
                            }
                        }

                        $selected = false;
                        $ignore = false;
                        $input_string = Tools::strtolower(LinevenRlpTools::replaceSpecialChars($input_string));
                        $input_string = str_replace('/', '\\/', $input_string);
                        foreach ($query as $item) {
                            if (!$ignore && trim($item) != '') {
                                // Search operator
                                $search_string = Tools::strtolower(LinevenRlpTools::replaceSpecialChars($item));
                                $search_string = str_replace('/', '\\/', $search_string);
                                // And operator
                                $operator = Tools::substr($search_string, 0, 1);
                                if ($operator == '+' || $operator == '-') {
                                    $search_string = Tools::substr($search_string, 1, Tools::strlen($search_string));
                                } else {
                                    $operator = 'none';
                                }
                                $result_match = false;
                                if (Tools::substr($search_string, 0, 1) == '"' &&
                                    Tools::substr($search_string, -1) == '"') {
                                    $result_match = preg_match(
                                        '/\b'.Tools::substr($search_string, 1, -1).'\b/',
                                        $input_string
                                    );
                                } else {
                                    $result_match = preg_match(
                                        '/'.$search_string.'/',
                                        $input_string
                                    );
                                }
                                // No operator
                                if ($operator == 'none' && $result_match == 1) {
                                    $selected = true;
                                }
                                // And operator
                                if ($operator == '+' && $result_match == 0) {
                                    $ignore = true;
                                }
                                // Not operator
                                if ($operator == '-' && $result_match == 1) {
                                    $ignore = true;
                                }
                            }
                        }
                        if ($selected && !$ignore) {
                            $selected_associations[] = $rlp_list[$i]['id'];
                        }
                    }
                    $in_sql = implode(',', $selected_associations);
                    return $in_sql;
                }
            }
        }
        return null;
    }

    /**
     * Get keywords by name.
     * @param string $association Association
     * @return void
     */
    private function searchProductsByKeywords($association)
    {
        $search_by = unserialize(Configuration::get('LINEVEN_RLP_KW_RULES_DFLT'));
        $query = explode(' ', trim($association['products_keywords']));
        if (isset($association['is_keywords_rules_active']) && $association['is_keywords_rules_active']) {
            $search_by = array(
                'reference' => $association['is_keywords_rules_reference'],
                'name' => $association['is_keywords_rules_name'],
                'description' => $association['is_keywords_rules_description']
            );
        }
        $input_string = array();
        if (in_array('name', $search_by) || (isset($search_by['name']) && $search_by['name'] == 1)) {
            $input_string[] = 'pl.`name`';
        }
        if (in_array('description', $search_by) || (isset($search_by['description']) && $search_by['description'] == 1)) {
            $input_string[] = 'pl.`description`';
            $input_string[] = 'pl.`description_short`';
        }
        if (in_array('reference', $search_by) || (isset($search_by['reference']) && $search_by['reference'] == 1)) {
            $input_string[] = 'p.`reference`';
        }

        if (count($input_string) == 0) {
            $input_string = 'pl.`name`';
        } else {
            if (count($input_string) == 1) {
                $input_string = $input_string[0];
            } else {
                $input_string = implode(', \'  \', ', $input_string);
                $input_string = 'CONCAT('.$input_string.')';
            }
        }

        $like = '';
        $and_like = '';
        $not_like = '';
        foreach ($query as $item) {
            if (trim($item) != '') {
                $operator = 'none';
                $search_string = Tools::strtolower($item);
                $exact_word = false;
                // And operator
                if (Tools::substr($item, 0, 1) == '+' || Tools::substr($item, 0, 1) == '-') {
                    $operator = Tools::substr($item, 0, 1);
                    $search_string = Tools::substr($item, 1, Tools::strlen($item));
                }
                if (Tools::substr(Tools::strtolower($search_string), 0, 1) == '"' &&
                    Tools::substr(Tools::strtolower($search_string), -1) == '"') {
                    $search_string = Tools::substr($search_string, 1, -1);
                    $exact_word = true;
                }
                $search_string = addslashes($search_string);
                if ($operator == 'none') {
                    if (Tools::strlen($like) != 0) {
                        $like .= ' OR input_string ';
                    }
                    if (!$exact_word) {
                        $like .= 'LIKE \'%'.$search_string.'%\'';
                    } else {
                        $like .= 'RLIKE \'[[:<:]]'.$search_string.'[[:>:]]\'';
                    }
                }
                if ($operator == '+') {
                    if (Tools::strlen($and_like) != 0) {
                        $and_like .= ' AND input_string ';
                    }
                    if (!$exact_word) {
                        $and_like .= 'LIKE \'%'.$search_string.'%\'';
                    } else {
                        $and_like .= 'RLIKE \'[[:<:]]'.$search_string.'[[:>:]]\'';
                    }
                }
                if ($operator == '-') {
                    if (Tools::strlen($not_like) != 0) {
                        $not_like .= ' AND input_string ';
                    }
                    if (!$exact_word) {
                        $not_like .= 'NOT LIKE \'%'.$search_string.'%\'';
                    } else {
                        $not_like .= 'NOT RLIKE \'[[:<:]]'.$search_string.'[[:>:]]\'';
                    }
                }
            }
        }
        $sql = new DbQuery();
        $sql->select('p.`id_product`, '.$input_string.'as input_string');
        $sql->from('product', 'p');
        $sql->join(Shop::addSqlAssociation('product', 'p'));
        $sql->leftJoin(
            'product_lang',
            'pl',
            'p.`id_product` = pl.`id_product`
                AND pl.`id_lang` = '.(int)$this->context->getIdLang().Shop::addSqlRestrictionOnLang('pl')
        );
        $where = 'product_shop.`id_shop` = '.(int)$this->context->getIdShop().'
            AND product_shop.`visibility` IN ('.$this->context->getVisibilitiesSql().')
            AND product_shop.`active` = 1
            AND product_shop.`available_for_order` = 1';
        $sql->where($where);
        $having = '(input_string '.$like.') '.
            ((Tools::strlen($and_like) != 0) ? ' AND (input_string '.$and_like.')' : '' ).
            ((Tools::strlen($not_like) != 0) ? ' AND (input_string '.$not_like.') ' : ' ' );

        $sql->having($having);
        $sql->groupBy('`id_product`');
        $sql->orderBy('pl.`name` ASC');
        if ($this->query->getLimit() != null) {
            $sql->limit($this->query->getLimit());
        }
        $results = Db::getInstance()->executeS($sql);
        $to = ((count($results) > $this->query->getLimit()) ? $this->query->getLimit() : count($results));
        for ($i = 0; $i < $to; $i++) {
            $this->addProductDisplayed($results[$i]['id_product'], $association);
            if (count($this->products_displayed) >= $this->query->getLimit()) {
                break;
            }
        }
    }

    /**
     * Add displayed  product.
     * @param int $id_product Product id
     * @param arrau $association Associations details
     * @return void
     */
    private function addProductDisplayed($id_product, $association)
    {
        if ($id_product) {
            if (!array_key_exists($id_product, $this->products_displayed) && !in_array($id_product, $this->query->getRelatedProducts())) {
                $this->products_displayed[$id_product] = array_merge(
                    array('id_product' => $id_product),
                    $association
                );
            }
        }
    }
}
