<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemBestSales extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{

    /**
     * LinevenRlpPluginSystemBestSales constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Displaying top-selling products.', 'PluginSystemBestSales');
        $this->admin_form_description = $translator->l('This plugin allow you to display top-selling products.', 'PluginSystemBestSales');
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        $sql = 'SELECT p.id_product
		FROM `' . _DB_PREFIX_ . 'product_sale` ps
		LEFT JOIN `' . _DB_PREFIX_ . 'product` p ON ps.`id_product` = p.`id_product`
		' . Shop::addSqlAssociation('product', 'p') . '
		WHERE product_shop.`active` = 1
            AND product_shop.`available_for_order` = 1
            AND product_shop.`visibility` IN (' . $context->getVisibilitiesSql() . ') '.
            (count($query->getRelatedProducts())
                ? ' AND p.`id_product` NOT IN ('.pSQL($query->getRelatedProductsSqlIds()).') '
                : ' '
            ).'
            ORDER BY ps.quantity DESC
            LIMIT '.(int)$query->getLimit();
        return Db::getInstance()->executeS($sql);
    }
}
