<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemCategory extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{

    /**
     * LinevenRlpPluginSystemCategory constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Always display products of the same category.', 'PluginSystemCategory');
        $this->admin_form_description = $translator->l('This plugin allow you to always display products of the category to which the reference product belongs.', 'PluginSystemCategory');
        // Default options values
        $this->plugin_options = array(
            'USE_DEFAULT_CATEGORY' => 1
        );
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        if (count($query->getRelatedProducts())) {
            if ($this->getPluginOption('USE_DEFAULT_CATEGORY')) {
                $sql = 'SELECT DISTINCT p.`id_product` FROM `' . _DB_PREFIX_ . 'product` p
                ' . Shop::addSqlAssociation('product', 'p') . '
                WHERE product_shop.`id_category_default` IN (SELECT ps2.`id_category_default` FROM `' . _DB_PREFIX_ . 'product_shop` ps2
                    WHERE ps2.`id_product` IN (' . $query->getRelatedProductsSqlIds() . ') AND ps2.`id_shop` = ' . (int)$context->getIdShop() . '
                )
                AND p.`id_product` NOT IN ('.pSQL($query->getRelatedProductsSqlIds()).')
                AND product_shop.`active` = 1
                AND product_shop.`available_for_order` = 1
                AND product_shop.`visibility` IN (' . $context->getVisibilitiesSql() . ')
                '.($query->isRandomSearch() ? 'ORDER BY RAND()' : '').'
                LIMIT ' . (int)$query->getLimit();
                return Db::getInstance()->executeS($sql);
            } else {
                $sql = 'SELECT DISTINCT cp.`id_product` FROM `' . _DB_PREFIX_ . 'category_product` cp
                LEFT JOIN `' . _DB_PREFIX_ . 'product` p ON (p.`id_product`= cp.`id_product`)
                ' . Shop::addSqlAssociation('product', 'p') . '
                WHERE cp.`id_category` IN (SELECT cp2.`id_category` FROM `' . _DB_PREFIX_ . 'category_product` cp2
                    WHERE cp2.`id_product` IN (' . $query->getRelatedProductsSqlIds() . '))
                AND cp.`id_product` NOT IN ('.pSQL($query->getRelatedProductsSqlIds()).')
                AND product_shop.`active` = 1
                AND product_shop.`available_for_order` = 1
                AND product_shop.`visibility` IN (' . $context->getVisibilitiesSql() . ')
                '.($query->isRandomSearch() ? 'ORDER BY RAND()' : '').'
                LIMIT ' . (int)$query->getLimit();
                return Db::getInstance()->executeS($sql);
            }
        }
        return array();
    }

    /**
     * Get admin form options.
     */
    public function getAdminFormOptions()
    {
        $translator = new LinevenRlpTranslator();
        return array(
            array(
                'type' => 'checkbox',
                'name' => 'USE_DEFAULT_CATEGORY',
                'options_name' => 'USE_DEFAULT_CATEGORY',
                'values' => array(
                    'query' => array(
                        array(
                            'id' => 'on',
                            'name' => $translator->l('Only use the default category of the product instead of all associated categories.', 'PluginSystemCategory'),
                            'val' => '1'
                        ),
                    ),
                    'id' => 'id',
                    'name' => 'name'
                ),
            )
        );
    }
}
