<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemFeaturedProducts extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{

    /**
     * LinevenRlpPluginSystemFeaturedProducts constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Display featured products.', 'PluginSystemFeaturedProducts');
        $this->admin_form_description = $translator->l('This plugin allow you to displays featured products associated to a category.', 'PluginSystemFeaturedProducts');
        // Default options values
        $this->plugin_options = array(
            'ID_CATEGORY' => 2,
            'USE_DEFAULT_CATEGORY' => 1
        );
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        if ($this->getPluginOption('USE_DEFAULT_CATEGORY')) {
            $sql = 'SELECT DISTINCT p.`id_product` FROM `' . _DB_PREFIX_ . 'product` p
                ' . Shop::addSqlAssociation('product', 'p') . '
                WHERE product_shop.`id_category_default` = '.(int)$this->getPluginOption('ID_CATEGORY').
                (count($query->getRelatedProducts())
                    ? ' AND p.`id_product` NOT IN ('.pSQL($query->getRelatedProductsSqlIds()).') '
                    : ' '
                ).'
                AND product_shop.`active` = 1
                AND product_shop.`available_for_order` = 1
                AND product_shop.`visibility` IN (' . $context->getVisibilitiesSql() . ')
                '.($query->isRandomSearch() ? 'ORDER BY RAND()' : '').'
                LIMIT ' . (int)$query->getLimit();
            return Db::getInstance()->executeS($sql);
        } else {
            $sql = 'SELECT DISTINCT cp.`id_product` FROM `' . _DB_PREFIX_ . 'category_product` cp
                LEFT JOIN `' . _DB_PREFIX_ . 'product` p ON (p.`id_product`= cp.`id_product`)
                ' . Shop::addSqlAssociation('product', 'p') . '
                WHERE cp.`id_category` = '.(int)$this->getPluginOption('ID_CATEGORY').
                (count($query->getRelatedProducts())
                    ? ' AND p.`id_product` NOT IN ('.pSQL($query->getRelatedProductsSqlIds()).') '
                    : ' '
                ).'
                AND product_shop.`active` = 1
                AND product_shop.`available_for_order` = 1
                AND product_shop.`visibility` IN (' . $context->getVisibilitiesSql() . ')
                '.($query->isRandomSearch() ? 'ORDER BY RAND()' : '').'
                LIMIT '.(int)$query->getLimit();
            return Db::getInstance()->executeS($sql);
        }
        return array();
    }

    /**
     * Get admin form options.
     */
    public function getAdminFormOptions()
    {
        $module_context = LinevenRlpContext::getContext();
        $translator = new LinevenRlpTranslator();
        $categories = Category::getCategories($module_context->current_id_lang, true, false);
        $categories_select = array();
        foreach ($categories as $category) {
            $categories_select[] = array(
                'id' => $category['id_category'],
                'name' => $category['name'].' ('.$category['id_category'].')'
            );
        };
        return array(
            array(
                'type' => 'select',
                'label' => $translator->l('Category to use', 'PluginSystemFeaturedProducts'),
                'name' => 'ID_CATEGORY',
                'options_name' => 'ID_CATEGORY',
                'options' => array(
                    'query' => $categories_select,
                    'id' => 'id',
                    'name' => 'name'
                ),
                'class' => 'chosen fixed-width-xxl'
            ),
            array(
                'type' => 'checkbox',
                'name' => 'USE_DEFAULT_CATEGORY',
                'options_name' => 'USE_DEFAULT_CATEGORY',
                'values' => array(
                    'query' => array(
                        array(
                            'id' => 'on',
                            'name' => $translator->l('Select only products with this category as the default category.', 'PluginSystemFeaturedProducts'),
                            'val' => '1'
                        ),
                    ),
                    'id' => 'id',
                    'name' => 'name'
                )
            )
        );
    }
}
