<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemHighlightingBrand extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{

    /**
     * LinevenRlpPluginSystemFeaturedProducts constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Highlighting a brand.', 'PluginSystemHighlightingBrand');
        $this->admin_form_description = $translator->l('This plugin allow you to displays products associated to a specific brand.', 'PluginSystemHighlightingBrand');
        // Default options values
        $this->plugin_options = array(
            'ID_BRAND' => 1
        );
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        if ((int)$this->getPluginOption('ID_BRAND') != 0) {
            $sql = 'SELECT DISTINCT p.`id_product` FROM `'._DB_PREFIX_.'product` p
            '.Shop::addSqlAssociation('product', 'p').'
            WHERE p.id_manufacturer = '.(int)$this->getPluginOption('ID_BRAND').
            (count($query->getRelatedProducts())
                ? ' AND p.`id_product` NOT IN ('.pSQL($query->getRelatedProductsSqlIds()).') '
                : ' '
            ).'
            AND product_shop.`active` = 1
            AND product_shop.`available_for_order` = 1
            AND product_shop.`visibility` IN ('.$context->getVisibilitiesSql().')
            '.($query->isRandomSearch() ? 'ORDER BY RAND()' : '').'
            LIMIT '.(int)$query->getLimit();
            return Db::getInstance()->executeS($sql);
        }
        return array();
    }

    /**
     * Get admin form options.
     */
    public function getAdminFormOptions()
    {
        $module_context = LinevenRlpContext::getContext();
        $translator = new LinevenRlpTranslator();
        $brands = Manufacturer::getManufacturers(false, $module_context->current_id_lang);
        $brands_select = array();
        foreach ($brands as $brand) {
            $brands_select[] = array(
                'id' => $brand['id_manufacturer'],
                'name' => $brand['name'].' ('.$brand['id_manufacturer'].')'
            );
        };
        return array(
            array(
                'type' => 'select',
                'label' => $translator->l('Brand to use', 'PluginSystemHighlightingBrand'),
                'name' => 'ID_BRAND',
                'options_name' => 'ID_BRAND',
                'options' => array(
                    'query' => $brands_select,
                    'id' => 'id',
                    'name' => 'name'
                ),
                'class' => 'chosen fixed-width-xxl'
            )
        );
    }
}
