<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemInPacks extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{
    /**
     * LinevenRlpPluginSystemInPacks constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Display products packs with a reference product.', 'PluginSystemInPacks');
        $this->admin_form_description = $translator->l('This plugin allow you to display packs containing a reference product.', 'PluginSystemInPacks');
        $this->id_column_name = 'id_product_pack';
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        if (count($query->getRelatedProducts())) {
            $sql = 'SELECT DISTINCT `id_product_pack` FROM `'._DB_PREFIX_.'pack` pck
                LEFT JOIN `'._DB_PREFIX_.'product` p ON (p.`id_product` = pck.`id_product_item`)'
                .Shop::addSqlAssociation('product', 'p').'
            WHERE pck.`id_product_item` IN ('.pSQL($query->getRelatedProductsSqlIds()).')
            AND pck.`id_product_pack` NOT IN ('.pSQL($query->getRelatedProductsSqlIds()).')
            AND product_shop.`active` = 1
            AND product_shop.`available_for_order` = 1
            AND product_shop.`visibility` IN ('.$context->getVisibilitiesSql().')
            GROUP BY `id_product_pack`
            '.($query->isRandomSearch() ? 'ORDER BY RAND()' : '').'
            LIMIT '.(int)$query->getLimit();
            return Db::getInstance()->executeS($sql);
        }
        return array();
    }
}
