<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemNewProducts extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{
    /**
     * LinevenRlpPluginSystemNewProducts constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Display new products.', 'PluginSystemNewProducts');
        $this->admin_form_description = $translator->l('This plugin allow you to display new products.', 'PluginSystemNewProducts');
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        $products = Product::getNewProducts($context->getIdLang(), 0, $query->getLimit());
        if ($products) {
            return $products;
        }
        return array();
    }
}
