<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpPluginSystemSupplier extends LinevenRlpPlugin implements LinevenRlpPluginInterface
{

    /**
     * LinevenRlpPluginSystemSupplier constructor.
     */
    public function __construct()
    {
        $translator = new LinevenRlpTranslator();
        $this->admin_listing_description = $translator->l('Always display products for the same default supplier.', 'PluginSystemSupplier');
        $this->admin_form_description = $translator->l('This plugin allow you to always display products for the same default supplier to which the reference product belongs.', 'PluginSystemSupplier');
    }

    /**
     * Run query.
     * @param LinevenRlpProductSearchContext $context Context
     * @param LinevenRlpProductSearchQuery $query Query
     */
    public function runQuery(
        LinevenRlpProductSearchContext $context,
        LinevenRlpProductSearchQuery $query
    ) {
        if (count($query->getRelatedProducts())) {
            $sql = 'SELECT DISTINCT p.`id_product` FROM `'._DB_PREFIX_.'product` p
            '.Shop::addSqlAssociation('product', 'p').'
            WHERE p.id_supplier IN (SELECT p2.id_supplier FROM `'._DB_PREFIX_.'product` p2
                WHERE p2.`id_product` IN ('.pSQL($query->getRelatedProductsSqlIds()).')
            )
            AND p.`id_product` NOT IN ('.pSQL($query->getRelatedProductsSqlIds()).')
            AND p.`id_supplier` <> 0
            AND product_shop.`active` = 1
            AND product_shop.`available_for_order` = 1
            AND product_shop.`visibility` IN ('.$context->getVisibilitiesSql().')
            '.($query->isRandomSearch() ? 'ORDER BY RAND()' : '').'
            LIMIT '.(int)$query->getLimit();
            return Db::getInstance()->executeS($sql);
        }
        return array();
    }
}
