<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpProductListPresenter
{
    protected $hook_code;               // Hook code
    protected $hook_folder;             // Hook folder
    protected $controller_name;         // Controller name
    protected $hook_classname;          // Hook classname
    protected $is_separate_results;     // Is separate results
    protected $products;                // Products
    protected $presenter;               // Presenter
    protected $is_ajax_put_to_cart;     // Ajax put to cart
    protected $is_price_display;        // Price display
    protected $title;                   // Title
    protected $template;                // Template
    protected $id_related_product;      // Id related product
    protected $is_async;                // Is async
    protected $is_refresh;              // Is refresh

    /**
     * constructor.
     * @param string $hook_code Hook code
     * @param string $hook_folder Hook folder
     * @param string $controller_name Controller name
     */
    public function __construct($hook_code, $hook_folder, $controller_name)
    {
        $this->products = array();
        $this->hook_code = $hook_code;
        $this->hook_folder = $hook_folder;
        $this->controller_name = $controller_name;
        $this->hook_classname = '';
        $this->is_separate_results = false;
        $this->is_ajax_put_to_cart = true;
        $this->is_price_display = (int)$this->getConfiguration('DISPLAY_PRICE');
        $this->template = Tools::strtolower($this->getConfiguration('DISPLAYING_MODE'));
        $this->id_related_product = 0;
        $this->is_async = false;
        $this->is_refresh = false;
    }

    /**
     * Set separate results.
     *
     * @param boolean $is_separate_results
     * @return void
     */
    public function setSeparateResults($is_separate_results)
    {
        $this->is_separate_results = $is_separate_results;
    }

    /**
     * Is separate results.
     *
     * @return boolean
     */
    public function isSeparateResults()
    {
        return $this->is_separate_results;
    }

    /**
     * Set products.
     *
     * @param array $products
     * @return void
     */
    public function setProducts($products)
    {
        $this->products = $products;
    }

    /**
     * Get products.
     *
     * @return array
     */
    public function getProducts()
    {
        return $this->products;
    }

    /**
     * Get template.
     *
     * @return string
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * Set Ajax put to cart.
     *
     * @param boolean $is_ajax
     * @return void
     */
    public function setAjaxPutToCart($is_ajax)
    {
        $this->is_ajax_put_to_cart = $is_ajax;
    }

    /**
     * Set display price.
     *
     * @param boolean $is_price_display
     * @return void
     */
    public function setPriceDisplay($is_price_display)
    {
        $this->is_price_display = $is_price_display;
    }

    /**
     * Set title.
     *
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * Get title.
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set hook classname.
     *
     * @param string $classname
     * @return void
     */
    public function setHookClassname($classname)
    {
        $this->hook_classname = $classname;
    }

    /**
     * Set id related product.
     *
     * @param int $id_related_product
     * @return void
     */
    public function setIdRelatedProduct($id_related_product)
    {
        $this->id_related_product = $id_related_product;
    }

    /**
     * Set is async.
     *
     * @param boolean $is_async Is async mode
     * @return void
     */
    public function setAsync($is_async)
    {
        $this->is_async = $is_async;
    }

    /**
     * Set refresh
     *
     * @param boolean $is_refresh is refresh (ajax)
     * @return void
     */
    public function setRefresh($is_refresh)
    {
        $this->is_refresh = $is_refresh;
    }

    /**
     * Present.
     */
    public function present()
    {
        $context = Context::getContext();
        $this->presenter = array(
            'hook_code' => $this->hook_code,
            'hook_folder' => $this->hook_folder,
            'controller_name' => $this->controller_name,
            'hook_class_name' => $this->hook_classname,
            'is_separate_results' => $this->is_separate_results,
            'title' => $this->title,
            'id_related_product' => $this->id_related_product,
            'is_async' => $this->is_async,
            'is_refresh' => $this->is_refresh,
            'add_prod_display' => Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'),
            'static_token' => Tools::getToken(false),
            'link' => Context::getContext()->link,
            'is_mobile' => $context->isMobile(),
            'price_display' => Product::getTaxCalculationMethod((int)$context->cookie->id_customer),
            'tax_enabled' => Configuration::get('PS_TAX') && !Configuration::get('AEUC_LABEL_TAX_INC_EXC'),
            'display_price' => $this->is_price_display,
            'display_cart' => (int)$this->getConfiguration('DISPLAY_CART'),
            'display_reduction' => (int)$this->getConfiguration('DP_REDUCTION'),
            'display_new_product' => (int)$this->getConfiguration('NEW_PRD'),
            'ajax_put_cart' => (int)$this->is_ajax_put_to_cart,
            'display_thumbnails_title' => (int)$this->getConfiguration('THUMB_DP_TITLE'),
            'display_thumbnails_description' => (int)$this->getConfiguration('THUMB_DP_DESC'),
            'description_height' => (int)(($this->getConfiguration('THUMB_DP_HEIGHT') != 0
                && $this->getConfiguration('THUMB_DP_HEIGHT') != '')
                ? $this->getConfiguration('THUMB_DP_HEIGHT') : '140'),
            'combinations_all' => (int)Configuration::get('LINEVEN_RLP_COMBINATIONS_ALL'),
            'combinations_add_to_cart' => true,
            'combinations_display_options' => (int)Configuration::get('LINEVEN_RLP_COMBINATIONS_DSP_OPT'),
            'template' => $this->template,
            'template_type' => $this->template,
            'template_class_name' => 'list'
        );

        // Products images
        $this->setProductImageDef();

        // Products
        $products_presenter = null;
        if ($this->presenter['template'] == 'theme' || Tools::strpos($this->presenter['template'], 'theme')) {
            $this->presenter['template_type'] = 'theme';
            $products_presenter = new LinevenRlpProductThemePresenter(
                (int)$this->getConfiguration('MAX_PRODUCTS')
            );
        } else {
            $products_presenter = new LinevenRlpProductClassicPresenter(
                (int)$this->getConfiguration('MAX_PRODUCTS'),
                $this->getConfiguration('IMAGE_TYPE_NAME')
            );
        }
        $this->presenter['sections'] = $products_presenter->present($this->products);

        // Combinations
        if ((int)$this->presenter['combinations_all'] == false) {
            $this->presenter['combinations_add_to_cart'] = !(int)Configuration::get('LINEVEN_RLP_COMBINATIONS_ADDCART');
        }

        // Partners
        $this->setPartners();

        // Templates
        switch ($this->getConfiguration('DISPLAYING_MODE')) {
            case RelatedProducts::$template_standard_classic:
            case RelatedProducts::$template_standard_list_a:
            case RelatedProducts::$template_standard_list_b:
                $this->presenter['template_class_name'] = 'list';
                break;
            case RelatedProducts::$template_standard_thumbnails:
                $this->presenter['template_class_name'] = 'thumbnails';
                break;
            case RelatedProducts::$template_standard_theme:
                $this->presenter['template_class_name'] = 'theme';
                break;
            default:
                $this->presenter['template_class_name'] = $this->getConfiguration('DISPLAYING_MODE');
                break;
        }
        return $this->presenter;
    }

    /**
     * Set product image definition.
     */
    private function setProductImageDef()
    {
        $this->presenter['image_type'] = $this->getConfiguration('IMAGE_TYPE_NAME');
        $this->presenter['image_width'] = $this->getConfiguration('IMAGE_TYPE_WIDTH');
        $this->presenter['image_height'] = $this->getConfiguration('IMAGE_TYPE_HEIGHT');
    }

    /**
     * Set partners.
     */
    private function setPartners()
    {
        $this->presenter['partners_reviews'] = false;
        $this->presenter['partners_reviews_module'] = null;
        $this->presenter['partners_reviews_module_instance'] = null;
        if (Configuration::get('LINEVEN_RLP_PARTNER_RVW_RATE')) {
            $this->presenter['partners_reviews'] = true;
            if (Configuration::get('LINEVEN_RLP_PARTNER_RVW_MODULE') == RelatedProducts::$partner_reviews_module_lineven
                && LinevenRlpPartners::verifyModule(RelatedProducts::$partner_reviews_module_lineven)) {
                $this->presenter['partners_reviews_module'] = RelatedProducts::$partner_reviews_module_lineven;
                $this->presenter['partners_reviews_module_instance'] =
                    Module::getInstanceByName(RelatedProducts::$partner_reviews_module_lineven);
            }
            if (Configuration::get('LINEVEN_RLP_PARTNER_RVW_MODULE') == RelatedProducts::$partner_reviews_module_prestashop
                && LinevenRlpPartners::verifyModule(RelatedProducts::$partner_reviews_module_prestashop)) {
                $this->presenter['partners_reviews_module'] = RelatedProducts::$partner_reviews_module_prestashop;
            }
            // Else is the standard hook
        }
    }

    /**
     * Get configuration.
     * @param string $suffix Suffix
     */
    private function getConfiguration($suffix)
    {
        return Configuration::get('LINEVEN_RLP_'.$this->hook_code.'_'.$suffix);
    }
}
