<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpProductPresenter
{
    protected $module_context;
    protected $max_products = 100;
    protected $id_lang = null;
    protected $presented_products = array();

    /**
     * Constructor.
     * @param int $max_products Max products
     * @param int $id_lang Id lang
     */
    public function __construct($max_products = 100, $id_lang = null)
    {
        $this->module_context = LinevenRlpContext::getContext();
        $this->max_products = 100;
        if ($max_products < 100 && $max_products != 0) {
            $this->max_products = $max_products;
        }
        $this->id_lang = $this->module_context->current_id_lang;
        if ($id_lang != null) {
            $this->id_lang = $id_lang;
        }
        $this->presented_products = array();
    }

    /**
     * Is product presented.
     *
     * @param int $id_product Product id
     * @return boolean
     */
    protected function isProductPresented($id_product)
    {
        if (!in_array($id_product, $this->presented_products)) {
            $this->presented_products[] = $id_product;
            return false;
        }
        return true;
    }

    /**
     * Check availability by quantity.
     *
     * @param array $association_row Association row
     * @param integer $allow_oosp Allow oosp
     * @param integer $quantity Quantity
     * @return boolean
     */
    protected static function checkAvailabilityByQuantity($allow_oosp, $quantity)
    {
        if (Configuration::get('LINEVEN_RLP_AVL_ZERO_QTY')) {
            if ($quantity > 0 || ($allow_oosp && $quantity <= 0)) {
                return true;
            }
            return false;
        }
        return true;
    }

    /**
     * Get thumbnails image product
     * @param $id_product int Product id
     * @param $id_image int Image id
     * @return mixed
     */
    public static function getThumbnailImage($id_product, $id_image = null)
    {
        if (empty($id_image)) {
            $id_image = Product::getCover($id_product);
            if (is_array($id_image) && !empty($id_image['id_image'])) {
                $id_image = (int)$id_image['id_image'];
            }
        }
        $imageManager = new PrestaShop\PrestaShop\Adapter\ImageManager(new PrestaShop\PrestaShop\Adapter\LegacyContext());
        return $imageManager->getThumbnailForListing($id_image);
    }
}
