<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpProductSearchQuery
{
    private $limit;
    private $sort_display_method;
    private $sort_display_way;
    private $is_random_plugins;
    private $is_random_search;

    private $id_product;
    private $related_products;
    private $hook;

    public function __construct()
    {
        $this->limit = 80;
        $this->related_products = array();
        $this->hook = null;
        $this->is_random_search = false;
        $this->is_random_plugins = false;
        $this->sort_display_method = RelatedProducts::$sort_display_default;
        $this->sort_display_way = RelatedProducts::$sort_way_asc;
    }

    /**
     * Set limit.
     * @param int $limit Limit
     * @return $this
     */
    public function setLimit($limit)
    {
        $this->limit = $limit + 20;
        return $this;
    }

    /**
     * Get limit.
     * @return int
     */
    public function getLimit()
    {
        return (int)$this->limit;
    }

    /**
     * Set hook.
     * @param string $hook Hook
     * @return $this
     */
    public function setHook($hook)
    {
        $this->hook = $hook;
        return $this;
    }

    /**
     * Get hook.
     * @return sring
     */
    public function getHook()
    {
        return $this->hook;
    }

    /**
     * Set is random plugins.
     * @param boolean $is_random_plugins Randomly plugins
     * @return $this
     */
    public function setRandomPlugins($is_random_plugins)
    {
        $this->is_random_plugins = $is_random_plugins;
        return $this;
    }

    /**
     * Is random plugins.
     * @return boolean
     */
    public function isRandomPlugins()
    {
        return $this->is_random_plugins;
    }

    /**
     * Set is random search.
     * @param boolean $is_random_search Randomly search
     * @return $this
     */
    public function setRandomSearch($is_random_search)
    {
        $this->is_random_search = $is_random_search;
        return $this;
    }

    /**
     * Is random search.
     * @return boolean
     */
    public function isRandomSearch()
    {
        return $this->is_random_search;
    }

    /**
     * Set sort display method.
     * @param string $sort_display_method Sort display method
     * @param string $sort_display_way Sort display way
     * @return $this
     */
    public function setSortDisplayMethod($sort_display_method, $sort_display_way)
    {
        $this->sort_display_method = $sort_display_method;
        $this->sort_display_way = $sort_display_way;
        return $this;
    }

    /**
     * Get sort display method.
     * @return string
     */
    public function getSortDisplayMethod()
    {
        return $this->sort_display_method;
    }

    /**
     * Get sort display way.
     * @return string
     */
    public function getSortDisplayWay()
    {
        return $this->sort_display_way;
    }

    /**
     * Add related product.
     * @param int $id_product
     * @return void
     */
    public function addRelatedProduct($id_product)
    {
        if (!in_array($id_product, $this->related_products)) {
            $this->related_products[] = $id_product;
        }
    }

    /**
     * Get related products.
     * @return array
     */
    public function getRelatedProducts()
    {
        return $this->related_products;
    }

    /**
     * Get sql related products ids.
     * @return string
     */
    public function getRelatedProductsSqlIds()
    {
        return implode(',', $this->related_products);
    }

    /**
     * Set id product
     * @param $id_product Product id
     * @return $this
     */
    public function setIdProduct($id_product)
    {
        $this->id_product = $id_product;
        $this->addRelatedProduct($id_product);
        return $this;
    }

    /**
     * Set default related products.
     * @param int $id_product
     * @return void
     */
    public function setDefaultRelatedProducts()
    {
        // Add related products in the cart
        if ((int)Configuration::get('LINEVEN_RLP_INCLUDE_CART')) {
            $cart = Context::getContext()->cart;
            foreach ($cart->getProducts() as $product) {
                $this->addRelatedProduct($product['id_product']);
            }
        }

        // Add related viewed products
        if ((int)Configuration::get('LINEVEN_RLP_INCLUDE_VIEWED')) {
            $lineven_cookie = new Cookie('lineven_cookie', '', 0);
            if ($lineven_cookie->exists()) {
                if (isset($lineven_cookie->related_product_viewed) && $lineven_cookie->related_product_viewed != '') {
                    $products_viewed = explode(',', $lineven_cookie->related_product_viewed);
                    if (is_array($products_viewed) && count($products_viewed)) {
                        foreach ($products_viewed as $id) {
                            $this->addRelatedProduct($id);
                        }
                    }
                }
            }
        }

        // Add related purchased products
        if (Configuration::get('LINEVEN_RLP_INCLUDE_ORDERS')
            && Context::getContext()->customer->isLogged()) {
            // For all products in orders
            $sql = 'SELECT od.`product_id` FROM `'._DB_PREFIX_.'orders` o
            INNER JOIN `'._DB_PREFIX_.'order_detail` od ON (o.`id_order` = od.`id_order`)
            WHERE o.`id_shop_group` = '.(int)Context::getContext()->shop->getContextShopGroupID().'
            AND o.`id_shop` = '.(int)Context::getContext()->shop->getContextShopID().'
            AND o.`id_customer` = '.Context::getContext()->customer->id;
            $orders_list = Db::getInstance()->ExecuteS($sql);
            foreach ($orders_list as $row) {
                $this->addRelatedProduct($row['product_id']);
            }
        }
    }
}
