<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

$module_context = LinevenRlpContext::getContext();
$translator = new LinevenRlpTranslator();

return array(
    'abm' => array(
        'icon' => 'abm',
        'name' => $translator->l('Absence Manager', 'ads.inc'),
        'description' => $translator->l('Promptly notify your customers of your absence (vacation, indisponibility, etc...) or temporary closure of your shop in several display modes (banners, popup).', 'ads.inc'),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=6964'
    ),
    'apo' => array(
        'icon' => 'apo',
        'name' => $translator->l('Additional products on order', 'ads.inc'),
        'description' => array(
            $translator->l('Increase sales by displaying additional products (cross selling) during the ordering process.', 'ads.inc'),
            $translator->l('This simple implementation module allows you to increase sales by displaying additional products to your customers based on purchases placed in the cart.', 'ads.inc'),
            $translator->l('You can then push your products that will allow your customers to complete their order (cross selling).', 'ads.inc')
        ),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=5296'
    ),
    'apc' => array(
        'icon' => 'apc',
        'name' => $translator->l('Add Automatically Products In Cart', 'ads.inc'),
        'description' => $translator->l('Increase your sales by automatically add products in the customer cart (cross selling) by simply setting your trigger rules.', 'ads.inc'),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=22494'
    ),
    'cai' => array(
        'icon' => 'cai',
        'name' => $translator->l('Customers additional informations', 'ads.inc'),
        'description' => array(
            $translator->l('Collect additional customers information during the registration or order a process.', 'ads.inc'),
            $translator->l('Design a fully customizable form to collect informations that you consider pertinantes.', 'ads.inc'),
            $translator->l('Your form can be in several languages, and supports multi-store mode.', 'ads.inc')
        ),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=17565'
    ),
    'hcom' => array(
        'icon' => 'hcom',
        'name' => $translator->l('Reviews, Advices, Ratings, SEO and Google Rich Snippets', 'ads.inc'),
        'description' => array(
            $translator->l('Allow your customers to post ratings and reviews on your shop and / or on products.', 'ads.inc'),
            $translator->l('You can also encourage your customers to post reviews after their order.', 'ads.inc'),
            $translator->l('Enable the Google Rich Snippet to improve the SEO of your shop in the Google search engines.', 'ads.inc')
        ),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=4999'
    ),
    'mgf' => array(
        'icon' => 'mgf',
        'name' => $translator->l('Mega Form', 'ads.inc'),
        'description' => array(
            $translator->l('Create, customize, display all types of forms wherever you want on your store.', 'ads.inc'),
            $translator->l('Exchange quickly with your customers with the thread.', 'ads.inc')
        ),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=30983'
    ),
    'oph' => array(
        'icon' => 'oph',
        'name' => $translator->l('Opening Hours', 'ads.inc'),
        'description' => $translator->l('Manage the daily opening hours of your shop. Also define exceptional closure schedules.', 'ads.inc'),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=45055'
    ),
    'pqt' => array(
        'icon' => 'pqt',
        'name' => $translator->l('Price Quote', 'ads.inc'),
        'description' => $translator->l('Allow your customers to make requests for quotes with a customizable form.', 'ads.inc'),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=17042'
    ),
    'rlp' => array(
        'icon' => 'rlp',
        'name' => $translator->l('Related Products - Cross selling All in One', 'ads.inc'),
        'description' => array(
            $translator->l('Increase your sales by incentives purchases (cross selling) using plugins and customized associations (products, categories, keywords, ...) based on the products consulted, the customer cart and orders.', 'ads.inc'),
            $translator->l('This simple implementation module allows you to make combination products based on your defined rules.', 'ads.inc'),
            $translator->l('So you can push your products according to your requirements to suggest them to your customers to complete their orders (cross selling).', 'ads.inc')
        ),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=7942'
    ),
    'spo' => array(
        'icon' => 'spo',
        'name' => $translator->l('Services Pack Order', 'ads.inc'),
        'description' => $translator->l('Suggest service packs to your customers to complete their order during the purchase process (extended withdrawal period, warranty period, free return, etc.).', 'ads.inc'),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=27940'
    ),
    'spl' => array(
        'icon' => 'spl',
        'name' => $translator->l('Advanced Splash Popup', 'ads.inc'),
        'description' => array(
            $translator->l('Quickly inform your customers by display a popup on your shop.', 'ads.inc'),
            $translator->l('Completely customize your popups to display messages , products and / or images.', 'ads.inc')
        ),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=13732'
    ),
    'wrn' => array(
        'icon' => 'wrn',
        'name' => $translator->l('Warning message popup', 'ads.inc'),
        'description' => array(
            $translator->l('Quickly warn your visitors, with a popup, about the contents of your shop (alcohol, adults products, legal age, ...).', 'ads.inc'),
            $translator->l('Then, visitors can access your shop if they agree with the terms and conditions.', 'ads.inc')
        ),
        'href' => 'http://addons.prestashop.com/'.$module_context->current_language['iso_code']
            .'/product.php?id_product=13222'
    )
);
