<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

$translator = new LinevenRlpTranslator();

// Admin Tabs
$tab = array(
    'classname_parent' => 'AdminCatalog',
    'classname' => 'AdminLinevenRelatedProducts',
    'default_name' => 'Related Products',
    'name' => $translator->l('Related Products', 'navigation.inc')
);
LinevenRlpTabs::addTab($tab);

return array(
    'options' => array(
        'default' => 'dashboard',
        'admin_tab' => array(
            'AdminLinevenRelatedProducts' => array(
                'shortcut' => 'associations:plugin_associations',
                'show_navigation' => false
            )
        )
    ),
    'tree' => array(
        'dashboard' => array(
            'label' => $translator->l('Dashboard', 'navigation.inc'),
            'controller' => 'Dashboard',
            'action' => 'index',
            'icon' => 'fa fa-tachometer'
        ),
        'settings' => array(
            'label' => $translator->l('General settings', 'navigation.inc'),
            'items' => array(
                'module' => array(
                    'label' => $translator->l('Module', 'navigation.inc'),
                    'controller' => 'Settings',
                    'action' => 'module',
                    'icon' => 'fa fa-puzzle-piece'
                )
            )
        ),
        'associations' => array(
            'label' => $translator->l('Associations', 'navigation.inc'),
            'items' => array(
                'rules' => array(
                    'label' => $translator->l('Rules', 'navigation.inc'),
                    'controller' => 'AssociationsSettings',
                    'action' => 'rules',
                    'icon' => 'fa fa-filter',
                ),
                'plugins' => array(
                    'label' => $translator->l('Plugins', 'navigation.inc'),
                    'controller' => 'Plugins',
                    'action' => 'list',
                    'icon' => 'fa fa-plug',
                    'items' => array(
                        'add' => array(
                            'label' => $translator->l('Declare a plugin', 'navigation.inc'),
                            'controller' => 'Plugins',
                            'action' => 'addEdit'
                        ),
                        'edit' => array(
                            'label' => $translator->l('Edit a plugin', 'navigation.inc'),
                            'controller' => 'Plugins',
                            'action' => 'addEdit'
                        )
                    )
                ),
                'plugin_associations' => array(
                    'label' => $translator->l('Associations', 'navigation.inc'),
                    'controller' => 'Associations',
                    'action' => 'list',
                    'icon' => 'fa fa-chain',
                    'items' => array(
                        'add' => array(
                            'label' => $translator->l('Create an association', 'navigation.inc'),
                            'controller' => 'Associations',
                            'action' => 'addEdit'
                        ),
                        'edit' => array(
                            'label' => $translator->l('Edit an association', 'navigation.inc'),
                            'controller' => 'Associations',
                            'action' => 'addEdit'
                        )
                    )
                ),
                'availability' => array(
                    'label' => $translator->l('Products availability', 'navigation.inc'),
                    'controller' => 'AssociationsSettings',
                    'action' => 'availability',
                    'icon' => 'fa fa-check-square-o',
                ),
                'display_settings' => array(
                    'label' => $translator->l('Display settings', 'navigation.inc'),
                    'controller' => 'AssociationsSettings',
                    'action' => 'display',
                    'icon' => 'fa fa-eye',
                ),
            )
        ),
        'hooks' => array(
            'label' => $translator->l('Hooks', 'navigation.inc'),
            'items' => array(
                'onhomepage' => array(
                    'label' => $translator->l('Homepage', 'navigation.inc'),
                    'controller' => 'Hooks',
                    'action' => 'onHomepage',
                    'icon' => 'fa fa-home',
                ),
                'oncolumn' => array(
                    'label' => $translator->l('In column', 'navigation.inc'),
                    'controller' => 'Hooks',
                    'action' => 'onColumn',
                    'icon' => 'fa fa-columns',
                ),
                'onproductpage' => array(
                    'label' => $translator->l('Product page', 'navigation.inc'),
                    'controller' => 'Hooks',
                    'action' => 'onProductPage',
                    'icon' => 'fa fa-book',
                ),
                'onquickview' => array(
                    'label' => $translator->l('Product quick view', 'navigation.inc'),
                    'controller' => 'Hooks',
                    'action' => 'onQuickView',
                    'icon' => 'fa fa-search',
                ),
                'onorderpage' => array(
                    'label' => $translator->l('Order page', 'navigation.inc'),
                    'controller' => 'Hooks',
                    'action' => 'onOrderPage',
                    'icon' => 'fa fa-shopping-cart'
                ),
                'onajaxcart' => array(
                    'label' => $translator->l('Ajax cart', 'navigation.inc'),
                    'controller' => 'Hooks',
                    'action' => 'onAjaxCart',
                    'icon' => 'fa fa-shopping-basket'
                )
            )
        ),
        'associated_modules' => array(
            'label' => $translator->l('Associated modules', 'navigation.inc'),
            'items' => array(
                'reviews' => array(
                    'label' => $translator->l('Reviews', 'navigation.inc'),
                    'controller' => 'AssociatedModules',
                    'action' => 'reviews',
                    'icon' => 'fa fa-comments'
                )
            )
        ),
        'tools' => array(
            'label' => $translator->l('Tools', 'navigation.inc'),
            'items' => array(
                'design' => array(
                    'label' => $translator->l('Design', 'navigation.inc'),
                    'controller' => 'Tools',
                    'action' => 'design',
                    'icon' => 'fa fa-paint-brush'
                )
            )
        ),
        'support' => array(
            'label' => $translator->l('Support', 'navigation.inc'),
            'items' => array(
                'changelog' => array(
                    'label' => $translator->l('Change log', 'navigation.inc'),
                    'controller' => 'Support',
                    'action' => 'changelog',
                    'icon' => 'fa fa-history'
                ),
                'informations' => array(
                    'label' => $translator->l('Informations', 'navigation.inc'),
                    'controller' => 'Support',
                    'action' => 'informations',
                    'icon' => 'fa fa-info',
                    'environment' => LinevenRlpContext::$environment_production
                ),
                'diagnostic' => array(
                    'label' => $translator->l('Diagnostic', 'navigation.inc'),
                    'controller' => 'Diagnostic',
                    'action' => 'dashboard',
                    'icon' => 'fa fa-medkit',
                    'environment' => LinevenRlpContext::$environment_production
                ),
                'testmode' => array(
                    'label' => $translator->l('Test mode', 'navigation.inc'),
                    'controller' => 'Support',
                    'action' => 'testmode',
                    'icon' => 'fa fa-moon-o',
                    'environment' => LinevenRlpContext::$environment_production
                )
            )
        )
    )
);
