<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

$module_context = LinevenRlpContext::getContext();
$translator = new LinevenRlpTranslator();
$languages = Language::getLanguages(false);

// Initialize message
$titles_translations = array(
    'default' => LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Those products may also interest you',
        'fr' => 'Ces produits sont susceptibles de vous intéresser',
        'de' => 'Diese Produkte könnten Sie interessieren',
        'es' => 'Estos productos pueden interesarle',
        'it' => 'Questi prodotti potrebbero interessarti',
        'pl' => 'Te produkty mogą Cię zainteresować',
        'pt' => 'Esses produtos podem lhe interessar'
    )),
    'home' => LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'So more',
        'fr' => 'Voir plus',
        'de' => 'Mehr anzeigen',
        'es' => 'Ver más',
        'it' => 'Vedi altro',
        'pl' => 'Zobacz więcej',
        'pt' => 'Ana paula'
    ))
);
// Default image to use
$products_image = ImageType::getImagesTypes('products', true);
$image_type = 1;
$image_type_width = 20;
$image_type_height = 20;
if (count($products_image)) {
    $product_image = end($products_image);
    $image_type = $product_image['id_image_type'];
    $image_type_name = $product_image['name'];
    $image_type_width = $product_image['width'];
    $image_type_height = $product_image['height'];
}

// Default plugin to use
$default_plugins = serialize(array(
    'ASSOCIATIONS' => array(
        'max_products' => 5,
        'options' => array()
    )
));

return array(
    array('LINEVEN_RLP_NOTIFICATION_INST', 0, true),
    array('LINEVEN_RLP_NOTIFICATION_UPD', 0, true),
    array('LINEVEN_RLP_ACTIVE', 0),
    array('LINEVEN_RLP_SPECIFIC_HOOK_DEF', serialize(array())),
    array('LINEVEN_RLP_ACTIVE_ASSOC_KW', 0),
    array('LINEVEN_RLP_ACTIVE_BO_ADM_PRD', 0),
    array('LINEVEN_RLP_INCLUDE_CART', 1),
    array('LINEVEN_RLP_INCLUDE_ORDERS', 0),
    array('LINEVEN_RLP_INCLUDE_VIEWED', 0),
    array('LINEVEN_RLP_COOKIE_PVIEWED_MAX', 10),
    array('LINEVEN_RLP_KW_RULES_DFLT', serialize(array('name'))),
    array('LINEVEN_RLP_COMBINATIONS_ALL', 0),
    array('LINEVEN_RLP_COMBINATIONS_ADDCART', 0),
    array('LINEVEN_RLP_COMBINATIONS_DSP_OPT', 0),
    array('LINEVEN_RLP_AVL_ZERO_QTY', 1),
    array('LINEVEN_RLP_AVL_VISIBILITY', serialize(array('both', 'catalog', 'search'))),
    array('LINEVEN_RLP_HOOK_PRODUCTFOOTER', 1),
    array('LINEVEN_RLP_OPP_DISPLAYING_MODE', 'LIST_A'),
    array('LINEVEN_RLP_OPP_HOOK_USE', 'FOOTER'),
    array('LINEVEN_RLP_OPP_IS_ASYNC', 0),
    array('LINEVEN_RLP_OPP_IMAGE_TYPE', $image_type),
    array('LINEVEN_RLP_OPP_IMAGE_TYPE_NAME', $image_type_name),
    array('LINEVEN_RLP_OPP_IMAGE_TYPE_WIDTH', $image_type_width),
    array('LINEVEN_RLP_OPP_IMAGE_TYPE_HEIGHT', $image_type_height),
    array('LINEVEN_RLP_OPP_DISPLAY_PRICE', 1),
    array('LINEVEN_RLP_OPP_DISPLAY_CART', 1),
    array('LINEVEN_RLP_OPP_THUMB_DP_TITLE', 0),
    array('LINEVEN_RLP_OPP_THUMB_DP_DESC', 0),
    array('LINEVEN_RLP_OPP_THUMB_DP_HEIGHT', 180),
    array('LINEVEN_RLP_OPP_NEW_PRD', 0),
    array('LINEVEN_RLP_OPP_DP_REDUCTION', 0),
    array('LINEVEN_RLP_OPP_SEPARATE_DISPLAY', 0),
    array('LINEVEN_RLP_OPP_TITLE', $titles_translations['default']),
    array('LINEVEN_RLP_OPP_MAX_PRODUCTS', 5),
    array('LINEVEN_RLP_OPP_PLUGINS', $default_plugins),
    array('LINEVEN_RLP_OPP_SORT_DISPLAY', 'DEFAULT'),
    array('LINEVEN_RLP_OPP_SORT_DISPLAY_WAY', 'asc'),
    array('LINEVEN_RLP_OPP_RANDOM_PLUGINS', 0),
    array('LINEVEN_RLP_OPP_RANDOM_SEARCH', 0),
    array('LINEVEN_RLP_HOOK_QUICKVIEW', 0),
    array('LINEVEN_RLP_OQV_DISPLAYING_MODE', 'THUMBNAILS'),
    array('LINEVEN_RLP_OQV_IS_ASYNC', 0),
    array('LINEVEN_RLP_OQV_TITLE', $titles_translations['default']),
    array('LINEVEN_RLP_OQV_MAX_PRODUCTS', 4),
    array('LINEVEN_RLP_OQV_IMAGE_TYPE', $image_type),
    array('LINEVEN_RLP_OQV_IMAGE_TYPE_NAME', $image_type_name),
    array('LINEVEN_RLP_OQV_IMAGE_TYPE_WIDTH', $image_type_width),
    array('LINEVEN_RLP_OQV_IMAGE_TYPE_HEIGHT', $image_type_height),
    array('LINEVEN_RLP_OQV_DISPLAY_PRICE', 1),
    array('LINEVEN_RLP_OQV_DISPLAY_CART', 1),
    array('LINEVEN_RLP_OQV_THUMB_DP_TITLE', 0),
    array('LINEVEN_RLP_OQV_THUMB_DP_DESC', 0),
    array('LINEVEN_RLP_OQV_THUMB_DP_HEIGHT', 180),
    array('LINEVEN_RLP_OQV_NEW_PRD', 0),
    array('LINEVEN_RLP_OQV_DP_REDUCTION', 0),
    array('LINEVEN_RLP_OQV_PLUGINS', $default_plugins),
    array('LINEVEN_RLP_OQV_SORT_DISPLAY', 'DEFAULT'),
    array('LINEVEN_RLP_OQV_SORT_DISPLAY_WAY', 'asc'),
    array('LINEVEN_RLP_OQV_RANDOM_PLUGINS', 0),
    array('LINEVEN_RLP_OQV_RANDOM_SEARCH', 0),
    array('LINEVEN_RLP_HOOK_HOME', 0),
    array('LINEVEN_RLP_OHP_DISPLAYING_MODE', 'THEME'),
    array('LINEVEN_RLP_OHP_IS_ASYNC', 0),
    array('LINEVEN_RLP_OHP_TITLE', $titles_translations['home']),
    array('LINEVEN_RLP_OHP_MAX_PRODUCTS', 5),
    array('LINEVEN_RLP_OHP_IMAGE_TYPE', $image_type),
    array('LINEVEN_RLP_OHP_IMAGE_TYPE_NAME', $image_type_name),
    array('LINEVEN_RLP_OHP_IMAGE_TYPE_WIDTH', $image_type_width),
    array('LINEVEN_RLP_OHP_IMAGE_TYPE_HEIGHT', $image_type_height),
    array('LINEVEN_RLP_OHP_DISPLAY_PRICE', 1),
    array('LINEVEN_RLP_OHP_DISPLAY_CART', 1),
    array('LINEVEN_RLP_OHP_IN_TAB', 0),
    array('LINEVEN_RLP_OHP_PLUGINS', $default_plugins),
    array('LINEVEN_RLP_OHP_SORT_DISPLAY', 'DEFAULT'),
    array('LINEVEN_RLP_OHP_SORT_DISPLAY_WAY', 'asc'),
    array('LINEVEN_RLP_OHP_RANDOM_PLUGINS', 0),
    array('LINEVEN_RLP_OHP_RANDOM_SEARCH', 0),
    array('LINEVEN_RLP_HOOK_COLUMN', 0),
    array('LINEVEN_RLP_OCL_DISPLAYING_MODE', 'CLASSIC'),
    array('LINEVEN_RLP_OCL_IS_ASYNC', 0),
    array('LINEVEN_RLP_OCL_TITLE', $titles_translations['default']),
    array('LINEVEN_RLP_OCL_IMAGE_TYPE', $image_type),
    array('LINEVEN_RLP_OCL_IMAGE_TYPE_NAME', $image_type_name),
    array('LINEVEN_RLP_OCL_IMAGE_TYPE_WIDTH', $image_type_width),
    array('LINEVEN_RLP_OCL_IMAGE_TYPE_HEIGHT', $image_type_height),
    array('LINEVEN_RLP_OCL_MAX_PRODUCTS', 5),
    array('LINEVEN_RLP_OCL_WITCH', 'LEFT'),
    array('LINEVEN_RLP_OCL_NEW_PRD', 0),
    array('LINEVEN_RLP_OCL_DP_REDUCTION', 0),
    array('LINEVEN_RLP_OCL_PLUGINS', $default_plugins),
    array('LINEVEN_RLP_OCL_SORT_DISPLAY', 'DEFAULT'),
    array('LINEVEN_RLP_OCL_SORT_DISPLAY_WAY', 'asc'),
    array('LINEVEN_RLP_OCL_RANDOM_PLUGINS', 0),
    array('LINEVEN_RLP_OCL_RANDOM_SEARCH', 0),
    array('LINEVEN_RLP_HOOK_SHOPPINGCART', 0),
    array('LINEVEN_RLP_OOP_TITLE', $titles_translations['default']),
    array('LINEVEN_RLP_OOP_MAX_PRODUCTS', 5),
    array('LINEVEN_RLP_OOP_DISPLAYING_MODE', 'LIST_A'),
    array('LINEVEN_RLP_OOP_HOOK_USE', 'FOOTER'),
    array('LINEVEN_RLP_OOP_IS_ASYNC', 0),
    array('LINEVEN_RLP_OOP_IMAGE_TYPE', $image_type),
    array('LINEVEN_RLP_OOP_IMAGE_TYPE_NAME', $image_type_name),
    array('LINEVEN_RLP_OOP_IMAGE_TYPE_WIDTH', $image_type_width),
    array('LINEVEN_RLP_OOP_IMAGE_TYPE_HEIGHT', $image_type_height),
    array('LINEVEN_RLP_OOP_DISPLAY_PRICE', 1),
    array('LINEVEN_RLP_OOP_DISPLAY_CART', 1),
    array('LINEVEN_RLP_OOP_THUMB_DP_TITLE', 0),
    array('LINEVEN_RLP_OOP_THUMB_DP_DESC', 0),
    array('LINEVEN_RLP_OOP_THUMB_DP_HEIGHT', 180),
    array('LINEVEN_RLP_OOP_NEW_PRD', 0),
    array('LINEVEN_RLP_OOP_DP_REDUCTION', 0),
    array('LINEVEN_RLP_OOP_SEPARATE_DISPLAY', 0),
    array('LINEVEN_RLP_OOP_PLUGINS', $default_plugins),
    array('LINEVEN_RLP_OOP_SORT_DISPLAY', 'DEFAULT'),
    array('LINEVEN_RLP_OOP_SORT_DISPLAY_WAY', 'asc'),
    array('LINEVEN_RLP_OOP_RANDOM_PLUGINS', 0),
    array('LINEVEN_RLP_OOP_RANDOM_SEARCH', 0),
    array('LINEVEN_RLP_OOP_REFRESH_MODE', 'NOTHING'),
    array('LINEVEN_RLP_OOP_REFRESH_DELAY', 300),
    array('LINEVEN_RLP_HOOK_AJAXCART', 0),
    array('LINEVEN_RLP_OAC_DISPLAYING_MODE', 'THUMBNAILS'),
    array('LINEVEN_RLP_OAC_IS_ASYNC', 0),
    array('LINEVEN_RLP_OAC_TITLE', $titles_translations['default']),
    array('LINEVEN_RLP_OAC_MAX_PRODUCTS', 5),
    array('LINEVEN_RLP_OAC_IMAGE_TYPE', $image_type),
    array('LINEVEN_RLP_OAC_IMAGE_TYPE_NAME', $image_type_name),
    array('LINEVEN_RLP_OAC_IMAGE_TYPE_WIDTH', $image_type_width),
    array('LINEVEN_RLP_OAC_IMAGE_TYPE_HEIGHT', $image_type_height),
    array('LINEVEN_RLP_OAC_DISPLAY_PRICE', 1),
    array('LINEVEN_RLP_OAC_DISPLAY_CART', 1),
    array('LINEVEN_RLP_OAC_THUMB_DP_TITLE', 0),
    array('LINEVEN_RLP_OAC_THUMB_DP_DESC', 0),
    array('LINEVEN_RLP_OAC_THUMB_DP_HEIGHT', 180),
    array('LINEVEN_RLP_OAC_NEW_PRD', 0),
    array('LINEVEN_RLP_OAC_DP_REDUCTION', 0),
    array('LINEVEN_RLP_OAC_PLUGINS', $default_plugins),
    array('LINEVEN_RLP_OAC_SORT_DISPLAY', 'DEFAULT'),
    array('LINEVEN_RLP_OAC_SORT_DISPLAY_WAY', 'asc'),
    array('LINEVEN_RLP_OAC_RANDOM_PLUGINS', 0),
    array('LINEVEN_RLP_OAC_RANDOM_SEARCH', 0),
    array('LINEVEN_RLP_DEFAULT_DESIGN', 1),
    array('LINEVEN_RLP_DESIGN_CLASSIC', ''),
    array('LINEVEN_RLP_DESIGN_LIST_A', ''),
    array('LINEVEN_RLP_DESIGN_LIST_B', ''),
    array('LINEVEN_RLP_DESIGN_THUMBNAILS', ''),
    array('LINEVEN_RLP_PARTNER_RVW_RATE', 0),
    array('LINEVEN_RLP_PARTNER_RVW_MODULE', RelatedProducts::$partner_reviews_module_prestashop),
    array('LINEVEN_RLP_BO_LIST_FILTER', 1)
);
