<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

require_once(dirname(__FILE__).'/../../relatedproducts.php');

class AdminLinevenRelatedProductsController extends ModuleAdminController
{
    /**
     * Constructor.
     * @return void
     */
    public function __construct()
    {
        $module_context = LinevenRlpContext::getContext();
        $module_context->setAccess(LinevenRlpContext::$access_by_admin_tab);

        $this->bootstrap = true;
        $this->table = 'rlp';
        $this->list_id = 'rlp';
        $this->className = 'AdminLinevenRelatedProducts';

        parent::__construct();

        $this->module->init(true);
    }
    
    /**
     * Init page header.
     */
    public function initPageHeaderToolbar()
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        $translator = new LinevenRlpTranslator();
        if (Tools::isSubmit($configuration->name.'_action') &&
            Tools::getValue($configuration->name.'_action') == 'addEdit') {
            $this->page_header_toolbar_btn['save_stay'] = array(
                'href' => '#',
                'js' => 'LinevenRlpModule.Associations.doOnClickAssociationSave('.(int)Tools::isSubmit('id').', true)',
                'desc' => $translator->l('Save and stay', 'AdminLinevenRelatedProducts'),
                'icon' => 'process-icon-save'
            );
            $this->page_header_toolbar_btn['save'] = array(
                'href' => '#',
                'js' => 'LinevenRlpModule.Associations.doOnClickAssociationSave('.(int)Tools::isSubmit('id').', false)',
                'desc' => $translator->l('Save', 'AdminLinevenRelatedProducts')
            );
            $this->page_header_toolbar_btn['cancel'] = array(
                'href' => $this->context->link->getAdminLink('AdminLinevenRelatedProducts'),
                'desc' => $translator->l('Cancel', 'AdminLinevenRelatedProducts')
            );
        } else {
            $this->page_header_toolbar_btn['new'] = array(
                'href' => LinevenRlpTools::getBackofficeURI('Associations', 'addEdit', 'associations:associations:add'),
                'desc' => $translator->l('New association', 'AdminLinevenRelatedProducts')
            );
            $this->page_header_toolbar_btn['refresh'] = array(
                'href' => LinevenRlpTools::getBackofficeURI('Associations', 'list', 'associations:associations'),
                'desc' => $translator->l('Refresh', 'AdminLinevenRelatedProducts')
            );
        }
        $this->page_header_toolbar_btn['module'] = array(
            'href' => LinevenRlpTools::getAdminModuleLink(),
            'desc' => $translator->l('Module', 'AdminLinevenRelatedProducts'),
            'icon' => 'icon-puzzle-piece lineven-icon-toolbar'
        );
        return parent::initPageHeaderToolbar();
    }
    
    /**
     * Display.
     *
     * @return void
     */
    public function display()
    {
        $this->context->smarty->assign(array(
            'content' => $this->module->getContent()
        ));
        parent::display();
    }

    /**
     * Set media.
     * @param boolean $isNewTheme Is new theme
     */
    public function setMedia($isNewTheme = false)
    {
        parent::setMedia(false);
        $this->module->setBackofficeMedia();
    }
}
