<?php
/**
 * Library for Lineven Prestashop Modules (Version 4.1.3)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class RelatedProductsServiceDispatcherModuleFrontController extends ModuleFrontController
{
    private $controller;

    /**
     *
     * @see ModuleFrontController::postProccess()
     */
    public function postProcess()
    {
        $this->callController('process');
    }

    /**
     * InitContent.
     *
     * @see ModuleFrontController::initContent()
     */
    public function initContent()
    {
        $this->callController('init_content');
        if ($this->controller) {
            if (method_exists(get_class($this->controller), 'send')) {
                $this->controller->send();
                exit;
            }
            if (property_exists(get_class($this->controller), 'params')) {
                die(Tools::jsonEncode($this->controller->params));
            }
            die();
        }
    }

    /**
     * Call controller.
     *
     * @param string $step Step
     */
    private function callController($step = 'process')
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        $module_context = LinevenRlpContext::getContext();
        if (Tools::isSubmit($configuration->name.'_service_controller') &&
            Tools::getValue($configuration->name.'_service_controller') != '' &&
            ((!Tools::isSubmit($configuration->name.'_service_controller_step') && $step == 'process') ||
                (Tools::isSubmit($configuration->name.'_service_controller_step') &&
                    Tools::getValue($configuration->name.'_service_controller_step') == $step
                ))) {
            if ($step == 'init_content') {
                parent::initContent();
            }
            $module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $this->init();
            $this->controller = LinevenRlpController::getController(
                Tools::ucfirst(Tools::getValue($configuration->name.'_service_controller')),
                LinevenRlpController::$controller_type_front_service
            );
            $this->controller->run();
        }
    }
}
