<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFrontServiceRefreshController
{
    public $params;

    /**
     * Run.
     *
     * @return void
     */
    public function run()
    {
        // Context
        $module_context = LinevenRlpContext::getContext();
        if ($module_context->isModuleActive()) {
            $configuration = LinevenRlpConfiguration::getConfiguration();
            $module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $configuration->getModule()->init();
            $render = array( 'html' => '');
            if (Tools::isSubmit('hook_code') && Tools::isSubmit('controller_name') && Tools::getValue('controller_name') != '') {
                $controller = LinevenRlpController::getController(Tools::getValue('controller_name'), LinevenRlpController::$controller_type_front_hook);
                $controller->params['refresh'] = true;
                if (Tools::isSubmit('id_related_product') && (int)Tools::getValue('id_related_product') != 0) {
                    $controller->params['id_related_product'] = (int)Tools::getValue('id_related_product');
                }
                if (Tools::getValue('controller_name') == 'ProductPage' &&
                    Configuration::get('LINEVEN_RLP_OPP_HOOK_USE') == RelatedProducts::$product_page_hook_use_tab) {
                    $controller->run('renderAsyncTabContent');
                    $render = $controller->params['async_tab_content_results'];
                } else {
                    $render['html'] = $controller->run('render');
                }
            }
            die(Tools::jsonEncode($render));
        }
    }

    /**
     * InitContent.
     *
     * @see LinevenModuleFrontController::initContent()
     */
    public function initContent()
    {
        parent::initContent();
        die();
    }
}
