<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFrontAjaxCartController extends LinevenRlpFrontOnHookController
{
    protected $hook_code = 'OAC';
    protected $hook_folder = 'ajaxcart';
    protected $hook_classname = 'ajaxcart';

    /**
     * Ajax cart action.
     * @return void
     */
    public function ajaxCartAction()
    {
        if ($this->module_context->isModuleActive() && Configuration::get('LINEVEN_RLP_HOOK_AJAXCART')) {
            $hook_presenter = $this->getHookPresenter();
            if ($hook_presenter) {
                $hook_presenter->setAjaxPutToCart(false);
                $this->presenter->setDatas($hook_presenter->present());
                Context::getContext()->smarty->assign(array(
                    'link' => Context::getContext()->link,
                    'configuration' => Context::getContext()->controller->getTemplateVarConfiguration()
                ));
                $this->presenter->addOutput(LinevenRlpPresenter::$output_type_template, $hook_presenter->getTemplate());
            }
        }
    }
}
