<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFrontHeaderController extends LinevenRlpController
{
    /**
     * Index action.
     * @return void
     */
    public function indexAction()
    {
        if ($this->module_context->isModuleActive()) {
            // For product viewed
            if (isset($this->params['cookie']->related_product_viewed)) {
                unset($this->params['cookie']->related_product_viewed);
            }
            if (Context::getContext()->controller->php_self == 'product') {
                $haystack_plugin = Configuration::get('LINEVEN_RLP_OPP_PLUGINS').
                    Configuration::get('LINEVEN_RLP_OQV_PLUGINS').
                    Configuration::get('LINEVEN_RLP_OHP_PLUGINS').
                    Configuration::get('LINEVEN_RLP_OCL_PLUGINS').
                    Configuration::get('LINEVEN_RLP_OOP_PLUGINS').
                    Configuration::get('LINEVEN_RLP_OAC_PLUGINS');
                $id_product = (int)Tools::getValue('id_product');
                if ($id_product && ((int)Configuration::get('LINEVEN_RLP_INCLUDE_VIEWED') ||
                        strpos($haystack_plugin, 'ALREADY_SEEN') !== false)) {
                    $lineven_cookie = new Cookie('lineven_cookie', '', 0);
                    $viewed_products_ids = $id_product;
                    if ($lineven_cookie->exists()) {
                        if (isset($lineven_cookie->related_product_viewed) && $lineven_cookie->related_product_viewed != '') {
                            $viewed_products_ids = $lineven_cookie->related_product_viewed;
                            $products_viewed = explode(',', $viewed_products_ids);
                            if (is_array($products_viewed)) {
                                if (!in_array($id_product, $products_viewed)) {
                                    array_unshift($products_viewed, $id_product);
                                    $max_products = 10;
                                    if ((int)Configuration::get('LINEVEN_RLP_COOKIE_PVIEWED_MAX') > 0 &&
                                        (int)Configuration::get('LINEVEN_RLP_COOKIE_PVIEWED_MAX') <= 99) {
                                        $max_products = (int)Configuration::get('LINEVEN_RLP_COOKIE_PVIEWED_MAX');
                                    }
                                    $products_viewed = array_slice($products_viewed, 0, $max_products);
                                    $viewed_products_ids = implode(',', $products_viewed);
                                }
                            }
                        }
                    }
                    $lineven_cookie->related_product_viewed = $viewed_products_ids;
                }
            }
            // Get all templates used only for page activated
            $templates_used = array();
            if (Configuration::get('LINEVEN_RLP_HOOK_PRODUCTFOOTER')) {
                $templates_used[Configuration::get('LINEVEN_RLP_OPP_DISPLAYING_MODE')] = array('folder' => 'productpage');
            }
            if (Configuration::get('LINEVEN_RLP_HOOK_QUICKVIEW')) {
                $templates_used[Configuration::get('LINEVEN_RLP_OQV_DISPLAYING_MODE')] = array('folder' => 'quickview');
            }
            if (Configuration::get('LINEVEN_RLP_HOOK_HOME')) {
                $templates_used[Configuration::get('LINEVEN_RLP_OHP_DISPLAYING_MODE')] = array('folder' => 'home');
            }
            if (Configuration::get('LINEVEN_RLP_HOOK_COLUMN')) {
                $templates_used[Configuration::get('LINEVEN_RLP_OCL_DISPLAYING_MODE')] = array('folder' => 'column');
            }
            if (Configuration::get('LINEVEN_RLP_HOOK_SHOPPINGCART')) {
                $templates_used[Configuration::get('LINEVEN_RLP_OOP_DISPLAYING_MODE')] = array('folder' => 'shoppingcart');
            }
            if (Configuration::get('LINEVEN_RLP_HOOK_AJAXCART')) {
                $templates_used[Configuration::get('LINEVEN_RLP_OAC_DISPLAYING_MODE')] = array('folder' => 'ajaxcart');
            }
            $assets = array();
            foreach ($templates_used as $template => $def) {
                $use_template_file = false;
                $template_folder = _LINEVEN_MODULE_RLP_REQUIRE_DIR_.'/views/templates/hook/';
                if (!array_key_exists($template, RelatedProducts::$native_templates)) {
                    if (is_file($template_folder.$def['folder'].'/'.Tools::strtolower($template).'.tpl')) {
                        $use_template_file = true;
                    } else {
                        $template = RelatedProducts::$template_standard_list_a;
                    }
                }
                if (!$use_template_file && !Configuration::get('LINEVEN_RLP_DEFAULT_DESIGN') && Configuration::get('LINEVEN_RLP_DESIGN_'.$template) != '') {
                    $assets[] = Minify_CSS::minify(
                        Configuration::get('LINEVEN_RLP_DESIGN_'.$template),
                        array(
                            'compress' => true,
                            'removeCharsets' => true,
                            'preserveComments' => false
                        )
                    );
                } else {
                    if (!$use_template_file) {
                        $template = str_replace('_', '-', $template);
                    }
                    Context::getContext()->controller->registerStylesheet(
                        'modules-relatedproducts-'.Tools::strtolower($template),
                        LinevenRlpTools::getShortURI().'/views/css/relatedproducts-'.Tools::strtolower($template).'.css',
                        array('media' => 'all')
                    );
                }
            }
            Context::getContext()->controller->registerStylesheet(
                'modules-relatedproducts-global',
                LinevenRlpTools::getShortURI().'/views/css/relatedproducts-global.css',
                array('media' => 'all')
            );
            Context::getContext()->controller->registerStylesheet(
                'modules-relatedproducts-column',
                LinevenRlpTools::getShortURI().'/views/css/relatedproducts-column.css',
                array('media' => 'all')
            );
            Context::getContext()->controller->registerJavascript(
                'modules-relatedproducts',
                LinevenRlpTools::getShortURI().'/views/js/relatedproducts.js'
            );
            Context::getContext()->controller->registerStylesheet(
                'modules-relatedproducts-busy-css',
                LinevenRlpTools::getShortURI().'/views/css/vendor/busy-load/app.min.css',
                array('media' => 'all')
            );
            Context::getContext()->controller->registerJavascript(
                'modules-relatedproducts-busy-js',
                LinevenRlpTools::getShortURI().'/views/js/vendor/busy-load/app.min.js'
            );
            if (version_compare(_PS_VERSION_, '1.7.6', '>=') &&
                (int)Configuration::get('LINEVEN_RLP_PARTNER_RVW_RATE') &&
                Configuration::get('LINEVEN_RLP_PARTNER_RVW_MODULE') == RelatedProducts::$partner_reviews_module_prestashop) {
                $cssUrl = '/modules/productcomments/views/css/productcomments.css';
                $jsUrl = '/modules/productcomments/views/js/jquery.rating.plugin.js';
                Context::getContext()->controller->registerStylesheet(sha1($cssUrl), $cssUrl, ['media' => 'all', 'priority' => 80]);
                Context::getContext()->controller->registerJavascript(sha1($jsUrl), $jsUrl, ['position' => 'bottom', 'priority' => 80]);
            }

            // JS Def
            $partners_reviews_module = false;
            $partners_reviews_module_grade_url = '';
            if ((int)Configuration::get('LINEVEN_RLP_PARTNER_RVW_RATE')) {
                if (version_compare(_PS_VERSION_, '1.7.6', '>=') &&
                    Configuration::get('LINEVEN_RLP_PARTNER_RVW_MODULE') == RelatedProducts::$partner_reviews_module_prestashop) {
                    $partners_reviews_module = RelatedProducts::$partner_reviews_module_prestashop;
                    $partners_reviews_module_grade_url = Context::getContext()->link->getModuleLink('productcomments', 'CommentGrade');
                } else {
                    $partners_reviews_module = Configuration::get('LINEVEN_RLP_PARTNER_RVW_MODULE');
                }
            }
            LinevenRlpPresenter::addJsDef(array(
                'refresh_mode' => Configuration::get('LINEVEN_RLP_OOP_REFRESH_MODE'),
                'refresh_delay' => Configuration::get('LINEVEN_RLP_OOP_REFRESH_DELAY'),
                'partners_reviews_module' => $partners_reviews_module,
                'partners_reviews_module_grade_url' => $partners_reviews_module_grade_url,
            ));
            $this->presenter->addData('assets', $assets);
            $this->presenter->addOutput(LinevenRlpPresenter::$output_type_template, 'header');
        }
    }

    /**
     * PostRun.
     *
     * @return void
     */
    public function postRun()
    {
        parent::postRun();
        // Render JS Def
        $this->presenter->renderJsDef(true, true);
    }
}
