<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFrontHomeController extends LinevenRlpFrontOnHookController
{
    protected $hook_code = 'OHP';
    protected $hook_folder = 'home';
    protected $hook_classname = 'home';

    /**
     * Render action.
     * Use for hook and for asynchronous mode.
     *
     * @return void
     */
    public function renderAction()
    {
        if ($this->module_context->isModuleActive()) {
            $hook_presenter = $this->getHookPresenter();
            if ($hook_presenter) {
                $hook_presenter->setAjaxPutToCart(true);
                $this->presenter->setDatas($hook_presenter->present());
                $this->presenter->addOutput(
                    LinevenRlpPresenter::$output_type_template,
                    $hook_presenter->getTemplate()
                );
            }
        }
    }

    /**
     * Index action.
     * @return void
     */
    public function indexAction()
    {
        if ($this->module_context->isModuleActive() && Configuration::get('LINEVEN_RLP_HOOK_HOME')) {
            $this->renderAction();
        }
    }
}
