<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFrontOnHookController extends LinevenRlpController
{
    protected $hook_code;
    protected $hook_folder;
    protected $hook_classname;

    /**
     * Get hook presenter.
     * @return void
     */
    protected function getHookPresenter()
    {
        // Context
        $context = Context::getContext();
        $list_presenter = new LinevenRlpProductListPresenter($this->hook_code, $this->hook_folder, $this->controller_name);
        $id_related_product = 0;
        $products = null;
        if ($context->controller->php_self == 'product') {
            if (Tools::isSubmit('id_product') && (int)Tools::getValue('id_product') != 0) {
                $id_related_product = (int)Tools::getValue('id_product');
            }
        }
        if (!isset($this->params['refresh']) && Configuration::get('LINEVEN_RLP_'.$this->hook_code.'_IS_ASYNC')) {
            $list_presenter->setAsync(true);
        } else {
            // From refresh
            if (isset($this->params['refresh']) && (int)$this->params['refresh']) {
                if (isset($this->params['id_related_product']) && (int)Tools::getValue('id_related_product') != 0) {
                    $id_related_product = (int)$this->params['id_related_product'];
                }
            }
            // Context
            $product_context = LinevenRlpProductSearchContext::getContext();

            // Products query
            $product_query = new LinevenRlpProductSearchQuery();
            $product_query->setLimit((int)Configuration::get('LINEVEN_RLP_' . $this->hook_code . '_MAX_PRODUCTS'));
            $product_query->setHook($this->hook_code);
            $product_query->setSortDisplayMethod(
                Configuration::get('LINEVEN_RLP_' . $this->hook_code . '_SORT_DISPLAY'),
                Configuration::get('LINEVEN_RLP_' . $this->hook_code . '_SORT_DISPLAY_WAY')
            );
            $product_query->setRandomPlugins((int)Configuration::get('LINEVEN_RLP_' . $this->hook_code . '_RANDOM_PLUGINS'));
            $product_query->setRandomSearch((int)Configuration::get('LINEVEN_RLP_' . $this->hook_code . '_RANDOM_SEARCH'));
            if ($id_related_product != 0) {
                $product_query->setIdProduct($id_related_product);
            } else {
                $product_query->setDefaultRelatedProducts();
            }
            $crossselling_search = new LinevenRlpCrossSellingProductSearchProvider();
            $crossselling_search->setResultsSeparated((int)Configuration::get('LINEVEN_RLP_' . $this->hook_code . '_SEPARATE_DISPLAY'));
            $crossselling_search->setSections(unserialize(Configuration::get('LINEVEN_RLP_' . $this->hook_code . '_PLUGINS')));
            $products = $crossselling_search->runQuery($product_context, $product_query);
        }
        if (isset($this->params['refresh']) && $this->params['refresh'] == true) {
            $list_presenter->setRefresh(true);
        }
        $list_presenter->setHookClassname($this->hook_classname);
        $list_presenter->setSeparateResults((int)Configuration::get('LINEVEN_RLP_'.$this->hook_code.'_SEPARATE_DISPLAY'));
        $list_presenter->setProducts($products);
        $list_presenter->setIdRelatedProduct($id_related_product);
        $list_presenter->setTitle(
            LinevenRlpTranslator::getTranslationFromConfiguration(
                'LINEVEN_RLP_'.$this->hook_code.'_TITLE',
                $this->translator->l('To complete your order, we offer you those products', 'OnHook')
            )
        );
        return $list_presenter;
    }
}
