<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFrontProductPageController extends LinevenRlpFrontOnHookController
{
    protected $hook_code = 'OPP';
    protected $hook_folder = 'productpage';
    protected $hook_classname = 'product-footer';

    /**
     * Render action.
     * Use for hook and for asynchronous mode.
     *
     * @return void
     */
    public function renderAction()
    {
        if ($this->module_context->isModuleActive()) {
            $hook_presenter = $this->getHookPresenter();
            if ($hook_presenter) {
                $hook_presenter->setAjaxPutToCart(false);
                $this->presenter->setDatas($hook_presenter->present());
                $this->presenter->addOutput(
                    LinevenRlpPresenter::$output_type_template,
                    $hook_presenter->getTemplate()
                );
            }
        }
    }

    /**
     * Footer action.
     * @return void
     */
    public function footerAction()
    {
        if ($this->module_context->isModuleActive() && Configuration::get('LINEVEN_RLP_HOOK_PRODUCTFOOTER') &&
            Tools::isSubmit('id_product') && (int)Tools::getValue('id_product') != 0) {
            $this->renderAction();
        }
    }

    /**
     * Widget action.
     * @return void
     */
    public function widgetAction()
    {
        if ($this->module_context->isModuleActive() &&
            Configuration::get('LINEVEN_RLP_OPP_HOOK_USE') == RelatedProducts::$hook_to_use_specific &&
            Tools::isSubmit('id_product') && (int)Tools::getValue('id_product') != 0) {
            $this->renderAction();
        }
    }

    /**
     * Extra content action.
     * @return void
     */
    public function extraContentPrepareAction()
    {
        $this->presenter->noRender();
        if ($this->module_context->isModuleActive() && Configuration::get('LINEVEN_RLP_HOOK_PRODUCTFOOTER') &&
            Tools::isSubmit('id_product') && (int)Tools::getValue('id_product') != 0) {
            $hook_presenter = $this->getHookPresenter();
            if ($hook_presenter) {
                return $hook_presenter;
            }
        }
        return false;
    }

    /**
     * Extra content for asynchronous mode action.
     * @return void
     */
    public function extraContentPrepareAsyncAction()
    {
        $this->presenter->noRender();
        if ($this->module_context->isModuleActive() && Configuration::get('LINEVEN_RLP_HOOK_PRODUCTFOOTER') &&
            Tools::isSubmit('id_product') && (int)Tools::getValue('id_product') != 0) {
            $list_presenter = new LinevenRlpProductListPresenter($this->hook_code, $this->hook_folder, $this->controller_name);
            $product_context = LinevenRlpProductSearchContext::getContext();
            $product_query = new LinevenRlpProductSearchQuery();
            $product_query->setHook($this->hook_code);
            $product_query->setIdProduct((int)Tools::getValue('id_product'));
            $crossselling_search = new LinevenRlpCrossSellingProductSearchProvider();
            $crossselling_search->setResultsSeparated((int)Configuration::get('LINEVEN_RLP_OPP_SEPARATE_DISPLAY'));
            $crossselling_search->setSections(unserialize(Configuration::get('LINEVEN_RLP_OPP_PLUGINS')));
            $products = $crossselling_search->runQuery($product_context, $product_query, false);
            $list_presenter->setAsync(true);
            $list_presenter->setHookClassname($this->hook_classname);
            $list_presenter->setSeparateResults((int)Configuration::get('LINEVEN_RLP_OPP_SEPARATE_DISPLAY'));
            $list_presenter->setProducts($products);
            $list_presenter->setIdRelatedProduct((int)Tools::getValue('id_product'));
            $list_presenter->setTitle(
                LinevenRlpTranslator::getTranslationFromConfiguration(
                    'LINEVEN_RLP_OPP_TITLE',
                    $this->translator->l('To complete your order, we offer you those products', 'OnHook')
                )
            );
            return $list_presenter;
        }
        return false;
    }

    /**
     * Extra content action.
     * @return void
     */
    public function extraContentOutputAction()
    {
        if (isset($this->params['extracontent_presenter'])
            && isset($this->params['extracontent_presenter_datas'])
            && isset($this->params['extracontent_section']) &&
            count($this->params['extracontent_section'])) {
            $presenter_datas = $this->params['extracontent_presenter_datas'];
            $presenter_datas['sections'] = array($this->params['extracontent_section']);
            $this->presenter->setDatas($presenter_datas);
            $this->presenter->addData('in_tab', true);
            if (isset($this->params['extracontent_section_key'])) {
                $this->presenter->addData('section_key', $this->params['extracontent_section_key']);
            }
            Context::getContext()->smarty->assign(array(
                'link' => Context::getContext()->link,
                'configuration' => Context::getContext()->controller->getTemplateVarConfiguration(),
                'page' => Context::getContext()->controller->getTemplateVarPage()
            ));
            $this->presenter->addOutput(
                LinevenRlpPresenter::$output_type_template,
                $presenter_datas['template']
            );
        }
    }

    /**
     * Render async tab content action.
     * Use for hook and for asynchronous mode in tab content.
     *
     * @return void
     */
    public function renderAsyncTabContentAction()
    {
        if ($this->module_context->isModuleActive()) {
            $hook_presenter = $this->getHookPresenter();
            $array = array();
            if ($hook_presenter) {
                $presenter_datas = $hook_presenter->present();
                if (is_array($presenter_datas) && isset($presenter_datas['sections']) && count($presenter_datas['sections'])) {
                    $controller = LinevenRlpController::getController('ProductPage', LinevenRlpController::$controller_type_front_hook);
                    $controller->params = $this->params;
                    foreach ($presenter_datas['sections'] as $section_key => $section) {
                        $controller->params['extracontent_presenter'] = $hook_presenter;
                        $controller->params['extracontent_presenter_datas'] = $presenter_datas;
                        $controller->params['extracontent_section'] = $section;
                        if (isset($section['products']) && count($section['products'])) {
                            $array[$section_key] = $controller->run('extraContentOutput');
                        }
                    }
                }
            }
            $this->params['async_tab_content_results'] = $array;
        }
    }
}
