<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFrontQuickViewController extends LinevenRlpFrontOnHookController
{
    protected $hook_code = 'OQV';
    protected $hook_folder = 'quickview';
    protected $hook_classname = 'product-quickview';

    /**
     * Index action.
     * @return void
     */
    public function indexAction()
    {
        if ($this->module_context->isModuleActive() && Configuration::get('LINEVEN_RLP_HOOK_QUICKVIEW') &&
            Tools::isSubmit('id_product') && (int)Tools::getValue('id_product') != 0) {
            $hook_presenter = $this->getHookPresenter();
            if ($hook_presenter) {
                $hook_presenter->setAjaxPutToCart(true);
                $this->presenter->setDatas($hook_presenter->present());
                $this->presenter->addOutput(
                    LinevenRlpPresenter::$output_type_template,
                    $hook_presenter->getTemplate()
                );
            }
        }
    }
}
