<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpFrontShoppingCartController extends LinevenRlpFrontOnHookController
{
    protected $hook_code = 'OOP';
    protected $hook_folder = 'shoppingcart';
    protected $hook_classname = 'shoppingcart-footer';

    /**
     * Render action.
     * Use for hook and for asynchronous mode.
     *
     * @return void
     */
    public function renderAction()
    {
        if ($this->module_context->isModuleActive()) {
            $hook_presenter = $this->getHookPresenter();
            if ($hook_presenter) {
                $hook_presenter->setAjaxPutToCart(false);
                $this->presenter->setDatas($hook_presenter->present());
                $this->presenter->addOutput(LinevenRlpPresenter::$output_type_template, $hook_presenter->getTemplate());
            }
        }
    }

    /**
     * Order page action.
     * @return void
     */
    public function shoppingCartAction()
    {
        if ($this->module_context->isModuleActive() && Configuration::get('LINEVEN_RLP_HOOK_SHOPPINGCART')) {
            $this->renderAction();
        }
    }

    /**
     * Widget action.
     * @return void
     */
    public function widgetAction()
    {
        if ($this->module_context->isModuleActive() &&
            Configuration::get('LINEVEN_RLP_OOP_HOOK_USE') == RelatedProducts::$hook_to_use_specific) {
            $this->renderAction();
        }
    }
}
