<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminHeaderController extends LinevenRlpController
{

    /**
     * Index action.
     * @return void
     */
    public function indexAction()
    {
        if ($this->module_context->isModuleActive() &&
            Context::getContext()->controller->controller_name == 'AdminProducts' &&
            Configuration::get('LINEVEN_RLP_ACTIVE_BO_ADM_PRD')) {
            $configuration = LinevenRlpConfiguration::getConfiguration();
            $id_product = (int)Tools::getValue('id_product');
            if (!(int)$id_product && version_compare(_PS_VERSION_, '1.7.0.0', '>=') &&
                version_compare(_PS_VERSION_, '1.7.4.0', '<')) {
                // Note for Prestashop - global is required to get the request object
                global $kernel;
                $request = $kernel->getContainer()->get('request');
                $id_product = (int)$request->get('id');
            } else {
                if (!(int)$id_product && version_compare(_PS_VERSION_, '1.7.4.0', '>=')) {
                    $sfContainer = PrestaShop\PrestaShop\Adapter\SymfonyContainer::getInstance();
                    if (!is_null($sfContainer) && !is_null($sfContainer->get('request_stack')->getCurrentRequest())) {
                        $request = $sfContainer->get('request_stack')->getCurrentRequest();
                        $id_product = (int)$request->get('id');
                    }
                }
            }
            if ((int)$id_product) {
                $product = new Product((int)$id_product, true, Context::getContext()->language->id, Context::getContext()->shop->id);
                if (Validate::isLoadedObject($product)) {
                    $associations_presenter = new LinevenRlpAssociationAdminListingPresenter();
                    $products = $associations_presenter->presentListForProduct(LinevenRlpAssociation::getByRelatedProduct($id_product));
                    Context::getContext()->smarty->assign(array(
                        'module_code' => $configuration->getCode(),
                        'module_name' => $configuration->getName(),
                        'link' => Context::getContext()->link,
                        'id_related_product' => $id_product,
                        'displayed_products' => $products
                    ));
                    Media::addJsDef(array(
                        'lineven_rlp_catalog_product' => array(
                            'tabName' => $this->translator->l('Related products', 'Header'),
                            'tabContent' => $configuration->getModule()->display(
                                _PS_MODULE_DIR_.$configuration->getModule()->name,
                                'views/templates/hook/admin/catalog/edit.tpl'
                            )
                        )
                    ));
                }
            }
            $this->presenter->noRender();
        }
    }
}
